#include "protos.h"

/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees, and by CSNET.  No warranties of
 * any kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed without prior consent of CSNET.
 * You may direct questions to nameserv@uiuc.edu
 */

/*LINTLIBRARY*/

static int meta_found = 0;
static int brkt_err = 0;
static int star_match __P((char *, char *));

int
pmatch(str, pat)
	char *str, *pat;
{
	register int range_cc, str_cc, in_range;
	int	c, low_lim;
	int	answer;

	str_cc = isupper(*str) ? tolower(*str) : *str;
	low_lim = 077777;
	switch (c = isupper(*pat) ? tolower(*pat) : *pat)
	{
	    case '[':
		in_range = 0;
		meta_found = 1;
		while (range_cc = *++pat)
		{
			if (range_cc == ']')
			{
				if (in_range)
					answer = pmatch(++str, ++pat);
				else
					answer = NO_MATCH;
				break;
			} else if (range_cc == '-')
			{
				if (low_lim <= str_cc & str_cc <= pat[1])
					in_range++;
				if (pat[1] != ']')
					range_cc = pat[1];
			}
			if (str_cc == (low_lim = range_cc))
				in_range++;
		}
		if (range_cc != ']')
		{
			brkt_err = 1;
			answer = NO_MATCH;
		}
		break;

	    case '?':
		meta_found = 1;
		if (str_cc)
			answer = pmatch(++str, ++pat);
		else
			answer = CONTINUE;
		break;

	    case '*':
		meta_found = 1;
		answer = star_match(str, ++pat);
		break;

	    case 0:
		if (!str_cc)
			answer = MATCH;
		else
			answer = NO_MATCH;
		break;
	default:
		if (str_cc == c)
			answer = pmatch(++str, ++pat);
		else if (str_cc < c)
			answer = CONTINUE;
		else
			answer = NO_MATCH;
		break;
	}

	if (answer != MATCH)
		answer = meta_found ? CONTINUE : answer;
	meta_found = 0;
	brkt_err = 0;
	return answer;
}

static int
star_match(str, pat)
	char *str, *pat;
{
	if (*pat == 0)
		return (MATCH);
	while (*str)
		if (pmatch(str++, pat) == MATCH)
			return (MATCH);
	return brkt_err ? NO_MATCH : CONTINUE;
}
