#include <stdio.h>
#include "declares.h"
#include "defines.h"
#include "install.h"

/*

	THIS IS ALPHA CODE - PLEASE DON'T CIRCULATE WIDELY YET!

	--   WHOIS++ query server   ---

This program is a jazzed up WHOIS, supporting the WHOIS++
protocol extensions to serve information from IAFA-style
records of attribute/value pairs. In effect, it is a
generalized template-oriented info browser.

For full details of this program, including design and
installation, see the README file.


Author:			Peter Deutsch (peterd@bunyip.com)
			Bunyip Information Systems Inc.

Last Modified:		August 7, 1992

Copyright:	(c) 1992, Bunyip Information Systems Inc.
		All rights reserved.
		May be freely redistributed provided this notice
		is retained and no fee charged.
		This software is supplied with NO WARRANTY,
		EXPRESSED OR IMPLIED.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1992, Bunyip Information Systems Inc.\n\
 All rights reserved.\
 May be freely redistributed provided this notice retained\
 and no fee charged\nIf you really want more details, call our lawyer\n\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)whoisd.c	7/8/92";
#endif /* not lint */


int towhois[2], toengine[2];
char *query_engine[2];
FILE *fptowhois, *fptoengine;

int fred;

main(argc, argv)
int argc;
char argv[]; {

char line [BUFSIZ];

/* print intro message. Eventually,  */
/* this will come from a file...     */

	fprintf (stderr, "\n--- Welcome to the WHOIS++ service  ---\n");
	fprintf (stderr, "Please enter search command (or 'help'): ");

/* fetch query from user */
	if (fgets(line, sizeof(line), stdin) == NULL) {
		fatal ("whoisd: can't get input line!");
		exit(1);
	}

	logit ("WHOIS++: User wants:", line);


 /* used way down in get_token() - don't touch! */
	ptr = line;


/* now parse it out and doit */
	switch( parse_query()) {

	case VALID_QUERY:
	   logit ("WHOIS++:", "valid query");
	   if (qptr->command_type == SYSTEM_COMMAND) {
	      logit ("WHOIS++:", "system command");
	      do_system_cmd(termptr);
	   }
	   else {
	      logit ("WHOIS++:", "sending query");
	      process_query (qptr);
	   }
	   break;

	case NO_QUERY:
		logit ("WHOIS++:", "no query");
		break;
		
	default:
		logit ("WHOIS++:", "BOGUS query!");
	}
		
      logit ("\nWHOIS++:", "budeee, budeee, dats all folks! :-)\n");

}

/* ----------------------------------------
		logit ()

   Eventually intended to log to a file.
   for now, just print to the screen.

   Note that if you want debugging messages, comment
   out the appropriate if(!strcmp().. line...

   ---------------------------------------- */

logit(primary, secondary) 
char *primary, *secondary; {



	if (!strcmp ("get_token:", primary)) {
		return;
	}
	if (!strncmp ("parse_term:", primary, 11)) {
		return;
	}
	if (!strncmp ("parse_query:", primary, 12)) {
		return;
	}
	if (!strncmp ("validate_term:", primary, 14)) {
		return;
	}
	if (!strncmp ("search_term:", primary, 12)) {
		return;
	}
	if (!strncmp ("set_cmd:", primary, 8)) {
		return;
	}
	if (!strncmp ("search_cmd:", primary, 11)) {
		return;
	}
	if (!strncmp ("system_cmd:", primary, 11)) {
		return;
	}

return;

	printf ("%s  ", primary);

	printf ("%s\n", secondary);

}


/* --------------------------------------------------
		fatal ()

	print gasping message and exit stage left...
   -------------------------------------------------- */
fatal(msg)
	char *msg;
{
	extern int errno;

	fprintf(stderr, "mywhoisd: %s: %d\r\n", msg, errno);
	exit(1);
}


/* -----------------------------------------------------------
			process_query ()

   routine to set up and launch query engine.
   calls send_query to send query to search engineand receive reply...

   for now, system sets up two pipese to send and receive messages, then
   forks search engine. Eventually, search engine should be able to run as
   a daemon and the query engine should be able to connect to it through
   a known port. We'll see...

   ------------------------------------------------------------ */

process_query(qptr)
struct query_type *qptr; {

int ch;



/* set up pipes for two way communication with engine */
	if (pipe(towhois) < 0)
		logit ("fatal:","pipe");
	if (pipe(toengine) < 0)
		logit ("fatal:","pipe");

/* set up arg list for exec of search engine */
	query_engine[0] = ENGINE_NAME;
	query_engine[1] = NULL;


/* now fork and launch engine */
	switch(fork()) {
	case -1:
		logit ("fatal:","switch");
	case 0:	
		/* child becomes search engine */
		/* ready child end of pipes    */
		(void)close(towhois[0]);
		(void)close(toengine[1]);

	/* now set up engine pipes as stdin and stdout */
		if (towhois[1] != 1) {
			(void)dup2(towhois[1], 1);
			}

		if (toengine[0] != 0) {
			(void)dup2(toengine[0], 0);
			}

/* and launch search engine... */
		execv(SEARCH_ENGINE, query_engine);
		logit ("process_query:", "oops, exec failed");
		exit(1);
		break;

	default:
		/* ready parent end of pipes */
		(void)close(towhois[1]);
		(void)close(toengine[0]);
	}

/*  we're in the parent, so set up pipes as file descriptors    */
/*  (so we can use fputs() and fgets() for reading and writing) */

if (!(fptowhois = fdopen(towhois[0], "r")))
		logit ("fatal:","fdopen");
	if (!(fptoengine = fdopen(toengine[1], "w")))
		logit ("fatal:","fdopen");
	logit ("send_term:", "- sending to engine");


/* now send the actual query to the engine */
	send_query (qptr);


/* and fetch the reply. this will           */
/* eventually be in its own routine         */
/* so it can supply proper formatting, etc. */

	logit ("process_query:", "- received from engine");
	while ((ch = getc(fptowhois)) != EOF) {
		if (ch == '\n')
			putchar('\r');
		putchar(ch);
	}



	logit ("process_query:", "End of reply\n");


}

/* ------------------------------------------------------------
            send_query ()

   Sends a complete query to the engine on the globally specified
   pipe.

  Remember, a query looks like:

( First two lines are the query header, followed by one or more terms )

	<versionnum> <nl>                 : String encoding version
	<constraintlist> <nl>             : string encoding global constraints
	[ <command> <contraintlist> <nl>  : an int for specifier, then ASCII
	  <attributestring> <nl>          : constraint list, then ATTRIBUTE
	  <valuestring> <nl> ]+           : list, then VALUE search string
	<nl>                              : newline by itself terminates search
	
	<versionnum> and <command> are ints and the rest
	are ASCII strings terminated with newlines.

   ------------------------------------------------------------ */
send_query(qptr)
struct query_type *qptr;  {


	logit ("send_query:", "into sendit");


/*  Now send a complete query to the engine */

/* first send query structure info */
/* (including version string)      */
	fputs(qptr->version, fptoengine);
	fputc('\n', fptoengine);
	
/* global constriants */
/* 	fputs(qptr->constraints, fptoengine);*/
 	fputs("global constraints", fptoengine);
	fputc('\n', fptoengine);


/* now set up and send each term in turn */

	termptr = qptr->termptr;
	while (termptr != NULL ) {
	   printf ("send_query: specifier is: < %d >\n", termptr->command);
	   fputc(termptr->command, fptoengine);

/*	fputs(termptr->constraints, fptoengine); */
	   fputs("some constraints", fptoengine);
	   fputc('\n', fptoengine);

	fputs(termptr->attribute, fptoengine);
	fputc('\n', fptoengine);

	fputs(termptr->value, fptoengine);
 	fputc('\n', fptoengine);
 	fputc('\n', fptoengine);
	termptr = termptr->nextptr;
	}

	fclose (fptoengine); /* have to close so child sees EOF */


}

/* ----------------------------------------
		do_system_cmd ()

   Will eventually process the various system
   commands. From now bark and die.

   ---------------------------------------- */
do_system_cmd (termptr)
struct term_type *termptr; {


	logit ("do_system_cmd:", "in do_system_cmd");

}
