#ifndef HTLIST_H
#define HTLIST_H

#include "HTUtils.h"  /* for BOOL type */

typedef struct _HTList HTList;

struct _HTList {
  void * object;
  HTList * next;
};

extern HTList *	HTList_new ();
extern void	HTList_delete (HTList *this);
extern void	HTList_addObject (HTList *this, void *newObject);
extern BOOL	HTList_removeObject (HTList *this, void *oldObject);
extern void *	HTList_removeLastObject (HTList *this);
extern void *	HTList_removeFirstObject (HTList *this);
#define 	HTList_isEmpty(this) (this ? this->next == NULL : YES)
extern int	HTList_count (HTList *this);
extern int	HTList_indexOf (HTList *this, void *object);
#define 	HTList_lastObject(this) \
  (this && this->next ? this->next->object : NULL)
extern void *	HTList_objectAt (HTList *this, int position);

/* Fast macro to traverse the list. Call it first with copy of list header :
   it returns the first object and increments the passed list pointer.
   Call it with the same variable until it returns NULL. */
#define HTList_nextObject(this) \
  (this && (this = this->next) ? this->object : NULL)

#endif HTLIST_H
