/* nblpd.c Version 0. 4 Feb 1992 */
/* Steven Bjork, bjork@telebit.com */

/* Daemon for printer hung off a NetBlazer. */

#include <stdio.h>
#include <signal.h>
#include <syslog.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/wait.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/ioctl.h>

#include "nblp.h"

main(argc, argv)
int argc;
char *argv[];
{
  int sockfd, servlen, newsockfd, lpsockfd, clilen, childpid;
  struct sockaddr_un cli_addr, serv_addr;
  struct sockaddr_in sa;
  struct hostent *hp;
  struct servent *sp;

  char *pname, *lprname;

  char xudsname[UDSMAX];
  char charbuf[MAXLINE];
  char hbufname[UDSMAX];

  pname = argv[0];
  lprname = argv[1];

  if (lprname == NULL) {
    logme("Missing printer specification.");
    exit(1);
  }

/* Become the Daemon. If 1, reap our zombies. */

  daemon_start(1);

  openlog("nblpd", LOG_PID);

/* Build socket name string. */
  strcpy(xudsname, XTFSNAME);
  strcat(xudsname, lprname);

/* Clean up any previous wreckage. */
  strcpy(charbuf, RMCMD);
  strcat(charbuf, xudsname);
  system(charbuf);

  if ( (sockfd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0 ) {
    logme("Failed to open stream socket.");
    exit(1);
  }

/* Build name into socket structure. */
  bzero((char *) &serv_addr, sizeof(serv_addr));
  serv_addr.sun_family = AF_UNIX;
  strcpy(serv_addr.sun_path, xudsname);
  servlen = strlen(serv_addr.sun_path) + sizeof(serv_addr.sun_family);

  if (bind(sockfd, (struct sockaddr *) &serv_addr, servlen) < 0) {
    logme("Bind UDS failure.");
    exit(1);
  }

/* Get IP address of host, where host is argv[1] minus last two chars. */
  strncpy(hbufname, lprname, strlen(lprname) - 2);
  if ((hp = gethostbyname(hbufname)) == NULL ) {
    logme("Address lookup failed.");
    exit(1);
  }

  bcopy((char *)hp->h_addr, (char *)&sa.sin_addr, hp->h_length);
  sa.sin_family = hp->h_addrtype;

/* Check for telnet service. */
  if ((sp = getservbyname("telnet","tcp")) == NULL ) {
    logme("Telnet service request failed.");
    exit(1);
  }

#ifdef NOTRAW
  sa.sin_port = sp->s_port;
#else
  sa.sin_port = NBRAWPORT + atoi(lprname + (strlen(lprname) - 2));
#endif NOTRAW

  if ((lpsockfd = socket(hp->h_addrtype, SOCK_STREAM, 0)) < 0) {
    logme("Printer socket open failure.");
    exit(1);
  }
      
/* We need to detect if this connection ever fails, such as from */
/* a NetBlazer reboot, and somehow reestablish the link. */
  if (connect(lpsockfd, &sa, sizeof(sa)) < 0) {
    logme("Printer connect failure.");
    exit(1);
  }

/* Superstition makes me use the value one here. */
  if (listen(sockfd, 1) != 0) {
    logme("Listen failed.");
    exit(1);
  }

/* For-ever, says Jane Siberry... The Speckless Sky.*/
  for ( ; ; ) {

    clilen = sizeof(cli_addr);
    newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr, &clilen);

    if (newsockfd < 0) {
      logme("Accept failure in UDS.");
      exit(1);
    }

    if ( (childpid = fork()) < 0) {
      logme("Fork failed.");
      exit(1);
    }

    else if (childpid == 0) {
      close(sockfd);
      sock2sock(newsockfd, lpsockfd);
      exit(0);
    }

    wait();
    close(newsockfd);
  }
}

int
sock2sock(insockfd, outsockfd)

     int insockfd, outsockfd;
{
  int n;
  char line[MAXLINE];

  for ( ; ; ) {
    n = readline(insockfd, line, MAXLINE);
    if (n == 0)
      return;
    else if (n < 0) {
      logme("sock2sock: Copy error in readline.");
      exit(1);
    }

    if (writen(outsockfd, line, n) != n) {
      logme("sock2sock: Copy error in writen.");
      exit(1);
    }
  }
}

/* All the madness with returns and newlines is due to telnet. Sigh. */
int
readline(fd, ptr, maxlen)

register int fd;
register char *ptr;
register int maxlen;
{
  int n, rc;
  char c;
  for (n = 1; n < maxlen; n++) {
    if ( (rc = read(fd, &c, 1)) == 1) {
      *ptr++ = c;
      if (c == '\n') {
        *--ptr = '\r' ;
       	ptr++ ;
       	*ptr++ = '\n' ;

/* Use raw option if running 1.4 or better. */
#ifdef NOTRAW
        n++;
        *ptr++ = '\n' ;
#endif NOTRAW

        n++;
	break;
      }
    } else if (rc == 0 ) {
      if (n == 1)
	return(0);
      else
	break;
    } else
      return(-1);
  }
  *ptr = 0;
  return(n);
}

writen(fd, ptr, nbytes)
register int fd;
register char *ptr;
register int nbytes;
{
  int nleft, nwritten;
  nleft = nbytes;
  while ( nleft > 0) {
    nwritten = write (fd, ptr, nleft);
    if (nwritten <=0)
      return (nwritten);
    nleft -= nwritten;
    ptr += nwritten;
  }
  return(nbytes - nleft);
}

extern int errno;

daemon_start(ignsigcld)
     int ignsigcld;
{
  register int childpid, fd;

  if (getppid() == 1)
    goto out;

  signal(SIGTTOU, SIG_IGN);
  signal(SIGTTIN, SIG_IGN);
  signal(SIGTSTP, SIG_IGN);

  if ( (childpid = fork()) < 0 ) {
    logme("Daemon: fork failed.");
    exit(1);
  }
  else if (childpid > 0)
    exit(0);

  if (setpgrp(0, getpid()) == -1) {
    logme("Daemon: process group change failed.");
    exit(1);
  }

  if ( (fd = open("/dev/tty", O_RDWR)) >= 0) {
    ioctl(fd, TIOCNOTTY, (char *)NULL);
    close(fd);
  }

 out:

  for (fd = 0; fd < NOFILE; fd++)
    close(fd);

  errno = 0;
  chdir("/");
  umask(0);

  if (ignsigcld) {
    int sig_child();
  signal(SIGCLD, sig_child);
  }
}

sig_child()
{
  int pid;
  union wait status;
  while ( (pid = wait3(&status, WNOHANG, (struct rusage *) 0)) > 0);
}

