      SUBROUTINE BICONG(JDIM,KDIM,NX,NY,J1,J2,DY,THICK1,TOP,RIGHT,ALEFT
     +                   ,X,Y)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXJ=165, MAXK=48, MAXJK=MAXJ*MAXK  )
      DIMENSION X(JDIM,KDIM),Y(JDIM,KDIM)
      COMMON/WORKSP/CLUS(MAXJ), WORK2(MAXJ,91)
C
C
C      J      REFERS TO THE X ( STREAMWISE ) DIRECTION
C      K      REFERS TO THE Y DIRECTION
C
C
C POINTS IN X DIRECTION
      NJ = NX
C POINTS IN Y DIRECTION
      NK = NY
C
C THICKNESS OF AIRFOIL ( 10% PARABOLIC BICONVEX )
      THICK = THICK1
C
C      BELOW, REGION IS [ -X1, X2 ] X [ 0, Y1 ]
C      AND AIRFOIL IS [ 0, 1] ON THE X AXIS
C -X1 IS LEFT BOUNDARY OF REGION
      X1 = -ALEFT
C X2 IS LENGTH OF REGION TO THE RIGHT OF THE AIRFOIL
      X2 = RIGHT - 1.
C TOP OF GRID, NUMBER OF CHORD LENGTHS PERP. TO 
C STREAMWISE DIRECTION
      Y1 = TOP
C
C        DEFINES THE FINE MESH
C
      NJM1=NJ-1
      NKM1=NK-1
      NJM2=NJ-2
      NKM2=NK-2
C
C     NUMBER OF POINTS ON AIRFOIL
C
      JBODY=J2-J1+1
      PI=3.141592654
C
C     PUT THE POINTS ON THE AIRFOIL
C
      DANG=PI/JBODY
C
      TWOTH=2.*THICK
      DO 1 J=J1,J2
      XI=J-J1+.5
C THIS USES COS ON [ 0, PI ]
      DEV=COS(XI*DANG)
C      X(J,1)=.5*(1.-DEV)
CJB
CJB      THIS ONE GIVES A LOT OF STRETCHING
CJB            X(1,J)=.5*(1.-DEV)
CJB
C        THIS GIVES LESS STRETCHING
              X( J, 1) = .5 * ( .5*(1.-DEV) + XI/JBODY )
C
    1 CONTINUE
CJB
CJB    PUT THE POINTS BEFORE THE AIRFOIL
CJB
      DX = X(J1,1)
      CALL CLUSTR(JDIM,ALEFT,0.,DX,J1,CLUS)
       DO 2 I = 2,J1
       JJ = J1 - I + 1
       X(JJ,1) = -CLUS(I)
2      CONTINUE       
CJB
CJB   PUT THE POINTS AFTER THE AIRFOIL
CJB
      DX = 1. - X(J2,1)
      NI = NJ-J2+1
      XMM = RIGHT - 1.0
      CALL CLUSTR(JDIM,XMM,0.,DX,NI,CLUS)
       DO 3 J = J2+1,NJ 
       I = J - J2 + 1
       X(J,1) = 1.0 + CLUS(I)
3      CONTINUE       
C
      DO 7 J=1,NJ
      XJ=X(J,1)
      DO 7 K=2,NK
      X(J,K)=XJ
    7 CONTINUE
CJB
CJB   PUT THE POINTS ABOVE THE AIRFOIL
CJB
      CALL CLUSTR(JDIM,TOP,0.,DY,NY,CLUS)
       DO 5 K = 1,NY
       Y(1,K) = CLUS(K)
5      CONTINUE       
       DO 6 K = 1,NY
       DO 6 J = 2,NX
       Y(J,K) = Y(1,K)
6      CONTINUE
C
      RETURN
      END
