      SUBROUTINE RHSY(JDIM,KDIM,Q,S,PRESS,XY,XYJ,ETT,FLUX)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON/BASE/
     1  JMAX,       KMAX,     JM,          KM,          JBEGIN,   JEND,
     1  KBEGIN,     KEND,     JPLUS(999),  JMINU (999), JLOW,     JUP,
     1  KLOW,       KUP,      PERIDC  ,    NP,          DT,   CP2TIM,
     1  FSMACH,     ALPHA,    GAMMA,       GAMI,        PI,
     1  DIS2X,      DIS2Y,    DIS4X,       DIS4Y,       PHIDT,    
     1  THETAD ,    RESID,    JACDT,       IPRINT,      NPCP,
     1  JTAIL1,     JTAIL2,   NUMITE ,     ISTART,      NSTEPS
      LOGICAL PERIDC  
      COMMON/GRID/DYM,YMAX,XMIN,XMAX,THICK
C
      DIMENSION Q(JDIM,KDIM,4),PRESS(JDIM,KDIM),S(JDIM,KDIM,4)
      DIMENSION XY(JDIM,KDIM,4),XYJ(JDIM,KDIM),ETT(JDIM,KDIM)
      DIMENSION FLUX(JDIM,KDIM,4)
C
C      CENTRAL DIFFERENCING USED IN ETA DIRECTION
      DO 20 K=KBEGIN,KEND
      DO 20 J=JLOW,JUP
         R1 = XY(J,K,3)
         R2 = XY(J,K,4)
         R0 = ETT(J,K)
C       RR IS J/RHO
         RR = 1./Q(J,K,1)
         U = Q(J,K,2)*RR
         V = Q(J,K,3)*RR
C
C       R1, R2 ARE EITHER D XI /DX, D ETA/DX, OR D XI /DY, D ETA/DY
C       QS IS EITHER CAP-U OR CAP-V ( CONTRAVARIANT VELOCITIES )
         QS = R0 +R1*U + R2*V
C
C       PRESSJ IS PRESSURE / J
         PRESSJ= PRESS(J,K)
C
         FLUX(J,K,1)= Q(J,K,1)*QS
         FLUX(J,K,2)= Q(J,K,2)*QS + R1*PRESSJ
         FLUX(J,K,3)= Q(J,K,3)*QS + R2*PRESSJ
         FLUX(J,K,4) = QS*( Q(J,K,4) + PRESSJ) - PRESSJ*R0
C
20    CONTINUE
C
      R0 = - .5*DT / (1. + PHIDT)
C          CENTRAL DIFFERENCE F
      DO 30 N=1,4
      DO 30 K=KLOW,KUP
      DO 30 J = JLOW,JUP
           S(J,K,N) = R0*( FLUX(J,K+1,N) - FLUX(J,K-1,N))
     1                 + S(J,K,N)
30    CONTINUE
C
      RETURN
      END
