C***********************************************************************
C FILE ORSPTR.FOR
C
C HISTORY: 25/2/90: COPIED FROM ORSPGB.FOR
C***********************************************************************
      SUBROUTINE ORSP(NBANDS,NKPTS,NRPLWV,NPLWKP,CPTWFN,CPTDUM,CCTDUM)
C=======================================================================
C
C }}}}}}}}}}}}}}}}}}}}}}}"" SUBROUTINE ORSP }}}}}}}}}}}}}}}}}}}}}}}}}}}}
C
C THIS SUBROUTINE ORTHOGONALISES THE WAVEFUNCTIONS OBTAINED AFTER
C INTEGRATING THE EQUATIONS OF MOTION FOR THE ELECTRONIC STATES
C=======================================================================
C IF CORE MEMORY IS LIMITED AND THE REAL SPACE WAVEFUNCTIONS HAVE BEEN
C RECALCULATED IN THE ELECTRON DYNAMICS SUBROUTINE THEN
C CPTWFN(NPLWV,NBANDS,NKPTS) SHOULD BE CHANGED TO CPTWFN(NRPLWV,NBANDS,
C NKPTS)
C=======================================================================
      IMPLICIT COMPLEX (C)
      DIMENSION CPTWFN(*)
C=======================================================================
C
C                  DIMENSION STATEMENTS
C
C CPTDUM = THE WAVEFUNCTION TO BE NORMALISED AND TO WHICH ALL HIGHER
C          BANDS WILL BE ORTHOGONALISED
C CCTDUM = THE COMPLEX CONJUGATE OF THE ABOVE
C=======================================================================
      DIMENSION CPTDUM(*) , CCTDUM(*)
C
      DO 2101 NN = 1 , NBANDS
        NINDW = NRPLWV * ( NN - 1 )
        DO 2110 M = 1 , NPLWKP
          CPTDUM(M) = CPTWFN(M+NINDW)
 2110   CONTINUE
C=======================================================================
C TAKE THE COMPLEX CONJUGATE OF THE WAVEFUNCTION
C=======================================================================
        DO 2120 M = 1 , NPLWKP
          CCTDUM(M) = CONJG (CPTDUM(M))
 2120   CONTINUE
C=======================================================================
C CALCULATE THE MAGNITUDE SQUARED OF THE WAVEFUNCTION
C=======================================================================
        CWFMAG = (0.0,0.0)
        DO 2121 M = 1 , NPLWKP
          CWFMAG = CWFMAG + CCTDUM(M) * CPTDUM(M)
 2121   CONTINUE
        WFMAG = REAL (CWFMAG)
C=======================================================================
C CHECK THAT IT IS NON-ZERO
C=======================================================================
        IF (WFMAG.EQ.0.0) THEN
C=======================================================================
C IF IT IS ZERO PRINT THE BAND AND K POINT INDICES AND HALT
C EXECUTION
C=======================================================================
          WRITE (*,2103) NN,M, CWFMAG,  NBANDS,NKPTS,NRPLWV,NPLWKP
2103      FORMAT(/,' IN ORSP: WAVEFUNCTIONS LINEARLY DEPENDENT',
     &     /,'          Band =', I5,',   K=',I5,',  CWFMAG=',2E13.6,
     &     /,'         inputs are NBANDS,NKPTS,NRPLWV,NPLWKP =',4I5,/)
      
          STOP
        ENDIF
        WFMINV = 1.0 / SQRT (WFMAG)
C=======================================================================
C NORMALISE THE WAVEFUNCTION AND ITS COMPLEX CONJUGATE
C=======================================================================
        DO 2122 M = 1 , NPLWKP
          CPTDUM(M) = WFMINV * CPTDUM(M)
          CCTDUM(M) = CONJG (CPTDUM(M))
 2122   CONTINUE
C=======================================================================
C STORE THE NORMALISED WAVEFUNCTION
C=======================================================================
        DO 2116 M = 1 , NPLWKP
          CPTWFN(M+NINDW) = CPTDUM(M)
 2116   CONTINUE
C=======================================================================
C NOW ORTHOGONALISE THE WAVEFUNCTIONS OF ALL THE HIGHER BANDS TO THE
C PRESENT WAVEFUNCTION
C=======================================================================
        DO 2102 MM = NN+1 , NBANDS
          NINDX = NRPLWV * ( MM - 1 )
C=======================================================================
C CALCULATE THE SCALAR PRODUCT OF THE WAVEFUNCTION OF THE HIGHER BAND
C AND THE NORMALISED COMPLEX CONJUGATE OF THE WAVEFUNCTION OF THE LOWER
C BAND
C=======================================================================
          CSCPD = (0.0,0.0)
          DO 2123 M = 1 , NPLWKP
            CSCPD = CSCPD + CCTDUM(M) * CPTWFN(M+NINDX)
 2123     CONTINUE
C=======================================================================
C ORTHOGONALISE THE WAVEFUNCTION OF THE HIGHER BAND TO THAT OF THE LOWER
C BAND
C=======================================================================
          DO 2124 M = 1 , NPLWKP
            CPTWFN(M+NINDX) = CPTWFN(M+NINDX) - CSCPD * CPTDUM(M)
 2124     CONTINUE
C=======================================================================
C MOVE ONTO THE NEXT BAND TO ORTHOGONALISE TO THE PRESENT BAND
C=======================================================================
 2102   CONTINUE
C=======================================================================
C MOVE ONTO THE NEXT BAND
C=======================================================================
 2101 CONTINUE
      RETURN
      END
