C--------------------------------------------------------------------------
C
C   I N T I N I
C
C   INITIALIZE CONSTANT TABLES NEEDED FOR INTEGRATION
C
C----------------------------------------------------------------------
      SUBROUTINE INTINI
C
C  CONSTANTS
C
      REAL  PI,PI2,CPI,DTORAD,RTODEG,
     .                  GRAVIT,OBLIQ
      COMMON /CONST/    PI,PI2,CPI,DTORAD,RTODEG,
     .                  GRAVIT,OBLIQ
C 
      INTEGER MAXOBJ, MAXDAY, MMM, ORDER
      PARAMETER (MAXOBJ=10, MAXDAY=10000, ORDER=7, MMM=3)
      REAL
     .    EPOCH,
     .    SBINC(0:ORDER,0:ORDER),
     .    DD(0:ORDER),
     .    KK(-MMM:MMM,-MMM:MMM),
     .    MASS(MAXOBJ),
     .    COORD(3,MAXOBJ),
     .    VELOC(3,MAXOBJ),
     .    XDIFF(3,MAXOBJ),       
     .    ACCEL(-MMM:MMM,3,MAXOBJ,0:1),
     .    ADIFF(maxobj,0:ORDER,3),  
     .    DISTNC(MAXOBJ,MAXOBJ)        
      INTEGER SWAP
C
      COMMON /INTTAB/    SBINC,DD,KK,
     .                   COORD,VELOC,MASS,
     .                   XDIFF,ACCEL,ADIFF,DISTNC,SWAP,
     .                   EPOCH
C
C  LOCAL VARIABLES
C
      INTEGER I,J,K 
      REAL
     .    SUM,
     .    C(-1:ORDER,0:MMM),
     .    CC(0:ORDER),
     .    R(0:ORDER,-MMM:MMM),
     .    FAC(0:ORDER),
     .    EE(0:ORDER)
C
C FACTORIALS OF 0..ORDER 
C
      FAC(0)=1 
      DO 10 I=1,ORDER     
         FAC(I)=I*FAC(I-1) 
 10   CONTINUE
C
C SIGNED BINOMIAL COEFFICIENTS
C
      DO 21 I=0,ORDER
        DO 20 J=0,I
           SBINC(I,J)=FAC(I)/FAC(J)/FAC(I-J)
           IF (MOD(J,2) .EQ. 1) SBINC(I,J)=-SBINC(I,J)
 20      CONTINUE 
 21   CONTINUE
C
C DD
C
      DD(0)=1 
      DO 31 I=1,ORDER
        SUM=0.0
        DO 30 J=0,I-1
           SUM=SUM-DD(J)/(I+1-J)
 30     CONTINUE
        DD(I)=SUM
 31   CONTINUE 
C
C CC
C
      DO 41 I=0,ORDER
        SUM=0.0 
        DO 40 K=0,I
           SUM=SUM+DD(K)*DD(I-K)
 40     CONTINUE
        CC(I)=SUM 
 41   CONTINUE 
C
C DD 
C
      DO 50 I=1,ORDER 
         DD(I)=DD(I)*(1-I)
 50   CONTINUE
C
C  EE
C
      DO 61 I=0,ORDER
         SUM=0.0
         DO 60 K=2,I+2
            SUM=SUM+CC(I+2-K)/K
 60      CONTINUE
         EE(I)=SUM 
 61   CONTINUE
C
C  C
C
      DO 70 I=0,MMM
         C(2*I+1,I)=1.0
 70   CONTINUE
      DO 72 J=1,ORDER
         DO 71 I=J/2 +1,MMM
            C(J,I)=C(J-2,I-1)-I*I*C(J,I-1) 
 71      CONTINUE
 72   CONTINUE
C
C  R
C
      DO 81 I=-MMM,MMM
         R(2*MMM,I)=1.0
         DO 80 J=2*MMM,1,-1
            R(J-1,I)=C(J,MMM)+I*R(J,I) 
 80      CONTINUE
 81   CONTINUE
C
C  KK
C
      DO 92 I=1,MMM
         DO 91 J=-MMM,MMM
            SUM=0.0 
            DO 90 K=2*MMM,0,-1
               SUM=(SUM+R(K,J)/(K+2)/(K+1))*I 
 90         CONTINUE
            KK(I,J)=SUM*I/FAC(MMM+J)/FAC(MMM-J)
            IF (MOD(MMM-J,2) .EQ. 1) KK(I,J)=-KK(I,J)
            KK(-I,-J)=KK(I,J)
 91      CONTINUE
 92   CONTINUE
C
      RETURN 
      END
