C--------------------------------------------------------------------
C
C   S  T  A  R  T  
C
C   START COMPUTES A SEQUENCE OF POINTS NEEDED BY THE INTEGRATION
C   PROCEDURE; THE INTERVAL BETWEEN SUCCESSIVE POINTS IS H DAYS.
C   THE POINTS ARE IMPROVED BY ITERATION UNTIL THE MAXIMUM DIFFERENCE
C   OF ACCELERATIONS OBTAINED IN TWO SUCCESSIVE ITERS IS LESS
C   THAN LIMIT (AU/D**2).
C
C----------------------------------------------------------------------
      SUBROUTINE START(H, LIMIT, ITERS)
      INTEGER
     .    ITERS  
      REAL
     .    H,          
     .    LIMIT     
C
C  CONSTANTS
C
      REAL  PI,PI2,CPI,DTORAD,RTODEG,
     .                  GRAVIT,OBLIQ
      COMMON /CONST/    PI,PI2,CPI,DTORAD,RTODEG,
     .                  GRAVIT,OBLIQ
C
C  
C
      INTEGER MAXOBJ, MAXDAY, MMM, ORDER
      PARAMETER (MAXOBJ=10, MAXDAY=10000, ORDER=7, MMM=3)
      REAL
     .    EPOCH,
     .    SBINC(0:ORDER,0:ORDER),
     .    DD(0:ORDER),
     .    KK(-MMM:MMM,-MMM:MMM),
     .    MASS(MAXOBJ),
     .    COORD(3,MAXOBJ),
     .    VELOC(3,MAXOBJ),
     .    XDIFF(3,MAXOBJ),      
     .    ACCEL(-MMM:MMM,3,MAXOBJ,0:1),
     .    ADIFF(maxobj,0:ORDER,3),  
     .    DISTNC(MAXOBJ,MAXOBJ)        
      INTEGER SWAP
C
      COMMON /INTTAB/    SBINC,DD,KK,
     .                   COORD,VELOC,MASS,
     .                   XDIFF,ACCEL,ADIFF,DISTNC,SWAP,
     .                   EPOCH
C
C  LOCAL VARIABLES
C
      INTEGER I,J,K,T,COUNT
      REAL
     .    SUM,X0,X1,X2,
     .    XX(-MMM:MMM,3,MAXOBJ)
      LOGICAL ITER , OK 
C
C  COMPUTE MUTUAL DISTANCES AT THE INITIAL EPOCH
C
      SWAP=0
      DO 11 I=1,MAXOBJ
         DO 10 J=I+1,MAXOBJ
            X0=COORD(1,I)-COORD(1,J)
            X1=COORD(2,I)-COORD(2,J)
            X2=COORD(3,I)-COORD(3,J)
            DISTNC(I,J)=SQRT(X0*X0+X1*X1+X2*X2)
            DISTNC(J,I)=DISTNC(I,J)
 10      CONTINUE
 11   CONTINUE
C
C  COMPUTE ACCELERATIONS FROM EQUATIONS OF MOTION
C
      DO 22 K=1,3
         DO 21 I=1,MAXOBJ
            SUM=0.0 
            DO 20 J=1,MAXOBJ
               IF (I .NE. J) THEN
                  SUM=SUM+MASS(J)*(COORD(K,J)-COORD(K,I))/
     .                            (DISTNC(I,J)**3)
               ENDIF
 20         CONTINUE
            ACCEL(0,K,I,SWAP)= GRAVIT*SUM
            ACCEL(0,K,I,1-SWAP)= ACCEL(0,K,I,SWAP)
 21      CONTINUE
 22   CONTINUE
C
C  FIRST GUESS OF COORDINATES
C
      DO 32 T=-MMM,MMM
         DO 31 K=1,3
            DO 30 I=1,MAXOBJ
              XX(T,K,I)=COORD(K,I)+H*T*VELOC(K,I)+
     .                             H*H*T*T*ACCEL(0,K,I,SWAP)/2
 30         CONTINUE
 31      CONTINUE
 32   CONTINUE
C
C  ITERATION LOOP BEGINS AT LABEL 40
C  ITERATE UNTIL THE REQUIRED ACCURACY IS OBTAINED 
C
      COUNT=1 
      ITER=.TRUE. 
 40   CONTINUE
C
C  REPEAT THE CALCULATIONS FOR EACH POINT T=-MMM .. -1, +1 .. +MMM
C
         DO 100 T=-MMM,MMM
            IF (T .NE. 0) THEN
C
C  FIND DISTANCES
C
               DO 51 I=1,MAXOBJ
                  DO 50 J=I+1,MAXOBJ
                     X0=XX(T,1,I)-XX(T,1,J)
                     X1=XX(T,2,I)-XX(T,2,J)
                     X2=XX(T,3,I)-XX(T,3,J)
                     DISTNC(I,J)=SQRT(X0*X0+X1*X1+X2*X2) 
                     DISTNC(J,I)=DISTNC(I,J)
 50               CONTINUE
 51            CONTINUE   
C
C  ACCELERATIONS FROM EQUATIONS OF MOTION
C
               DO 62 K=1,3
                  DO 61 I=1,MAXOBJ
                     SUM=0.0
                     DO 60 J=1,MAXOBJ
                        IF (J .NE. I) THEN
                           SUM=SUM+MASS(J)*
     .                         (XX(T,K,J)-XX(T,K,I))/
     .                         (DISTNC(I,J)**3)
                        ENDIF
 60                  CONTINUE 
                     ACCEL(T,K,I,SWAP)=GRAVIT*SUM
 61               CONTINUE
 62            CONTINUE   
            ENDIF
 100     CONTINUE
C
C  UNLESS WE ARE IN THE FIRST ITERATION, COMPUTE DIFFERENCES 
C  OF ACCELERATIONS BETWEEN SUCCESSIVE ITERS
C
         IF (COUNT .GT. 1) THEN
            OK=.TRUE.
            DO 111 T=-MMM,MMM
               DO 110 I=1,MAXOBJ 
                  OK=ABS(ACCEL(T,1,I,SWAP)-ACCEL(T,1,I,1-SWAP))
     .              +ABS(ACCEL(T,2,I,SWAP)-ACCEL(T,2,I,1-SWAP))
     .              +ABS(ACCEL(T,3,I,SWAP)-ACCEL(T,3,I,1-SWAP))
     .              .LE. LIMIT
                  IF (.NOT. OK) GOTO 120
  110          CONTINUE
  111       CONTINUE
  120       ITER=.NOT. OK
         ENDIF 
C
C  CONTINUE ITERATION IF ANY OF THE DIFFERENCES IS TOO LARGE
C
         IF (ITER) THEN
            DO 133 T=-MMM,MMM
               DO 132 K=1,3
                  DO 131 I=1,MAXOBJ
                     SUM=0.0
                     DO 130 J=-MMM,MMM
                        SUM=SUM+KK(T,J)*ACCEL(J,K,I,SWAP)
 130                 CONTINUE
                     XX(T,K,I)=COORD(K,I)+H*T*VELOC(K,I)+H*H*SUM
 131              CONTINUE
 132           CONTINUE 
 133        CONTINUE
            COUNT=COUNT+1
         ENDIF
C 
C
         SWAP = 1-SWAP
      IF (ITER) GOTO 40
      SWAP = 1-SWAP
C
C  ITERATION FINISHED 
C  COMPUTE FINAL DIFFERENCES
C
      DO 142 K=1,3
         DO 141 I=1,MAXOBJ
            COORD(K,I)=XX(MMM,K,I) 
            SUM=0.0
            DO 140 J=-MMM,MMM
               SUM=SUM+(KK(MMM,J)-KK(MMM-1,J))*ACCEL(J,K,I,SWAP)
 140        CONTINUE
            XDIFF(K,I)=H*(VELOC(K,I) + H*SUM) 
 141     CONTINUE
 142  CONTINUE 
      ITERS=COUNT 
      RETURN
      END
