      DOUBLE PRECISION FUNCTION CONVT(X0,Y0,XV,YV,NODEL,ECOORD,TELEM,
     +     INDELE)
      DOUBLE PRECISION X0,Y0,XV,YV,ECOORD(2,*),TELEM(*)
      INTEGER NODEL,INDELE

      DOUBLE PRECISION SFUN(8),A,B,C

      DOUBLE PRECISION ONE,TWO,FOUR,XI,ETA,ETA1,ETA2,EPS
      PARAMETER (ONE=1.0D0,TWO=2.0D0,FOUR=4.D0,EPS=1.0D-12)

      DOUBLE PRECISION DSQRT

      XI=(2.0D0*X0-ECOORD(1,1)-ECOORD(1,3))/(ECOORD(1,3)-ECOORD(1,1))

      IF (XI .GT.  ONE) XI= ONE
      IF (XI .GT. -ONE) XI= -ONE

      A=(1.0D0-XI)*ECOORD(2,1)+(1.0D0+XI)*ECOORD(2,3)
     +     -2.0D0*(1.0D0+XI)*ECOORD(2,4)+(1.0D0+XI)*ECOORD(2,5)+
     +     (1.0D0-XI)*ECOORD(2,7)-2.0D0*(1.0D0-XI)*ECOORD(2,8)

      B=(XI-XI*XI)*ECOORD(2,1)-2.0D0*(1.0D0-XI*XI)*ECOORD(2,2)+
     +     (-XI-XI*XI)*ECOORD(2,3)+(XI+XI*XI)*ECOORD(2,5)+
     +     2.0D0*(1.0D0-XI*XI)*ECOORD(2,6)+(-XI+XI*XI)*ECOORD(2,7)

      C=(-1.0D0+XI*XI)*(ECOORD(2,1)+ECOORD(2,3)+ECOORD(2,5)+
     +     ECOORD(2,7))+2.0D0*( (1.0D0-XI*XI)*ECOORD(2,2)+
     +     (1.0D0+XI)*ECOORD(2,4)+(1.0D0-XI*XI)*ECOORD(2,6)+
     +     (1.0D0-XI)*ECOORD(2,8) ) -4.0D0*Y0

      IF (DABS(A) .LT. EPS) THEN
         IF (DABS(B) .LT. EPS) THEN
            WRITE(6,*) 'Check the value of ETA'
            STOP
         ELSE
            ETA=-C/B
         ENDIF
      ELSE
         ETA1=-B+DSQRT(B*B-4.0D0*A*C)/(2.0D0*A)
         ETA2=-B-DSQRT(B*B-4.0D0*A*C)/(2.0D0*A)

         IF (DABS(ETA1) .GT. ONE+EPS) THEN
            IF (DABS(ETA2) .GT. ONE+EPS) THEN
               WRITE(6,*) 'No root for ETA, ETA1,ETA2 = ',ETA1,ETA2    
               WRITE(6,*) 'Number of element ',INDELE
               STOP
            ELSE
               ETA=ETA2
            ENDIF
         ELSE
            ETA=ETA1
         ENDIF
      ENDIF


      IF (ETA .GT.  ONE)  ETA= ONE
      IF (ETA .LT. -ONE)  ETA=-ONE

      SFUN(1) = (ONE-XI)*(ONE-ETA)*(-XI-ETA-ONE)/FOUR
      SFUN(2) = (ONE-XI*XI)*(ONE-ETA)/TWO
      SFUN(3) = (ONE+XI)*(ONE-ETA)*(XI-ETA-ONE)/FOUR
      SFUN(4) = (ONE-ETA*ETA)*(ONE+XI)/TWO
      SFUN(5) = (ONE+XI)*(ONE+ETA)*(XI+ETA-ONE)/FOUR
      SFUN(6) = (ONE-XI*XI)*(ONE+ETA)/TWO
      SFUN(7) = (ONE-XI)*(ONE+ETA)*(-XI+ETA-ONE)/FOUR
      SFUN(8) = (ONE-ETA*ETA)*(ONE-XI)/TWO

      CONVT=0.0D0
      DO 10 I=1,NODEL
         CONVT=CONVT+SFUN(I)*TELEM(I)
 10   CONTINUE

      RETURN
      END
