/*--------------------------------------------------------------------------*
 *
 * Usage :
 *
 *   hdf2ras hdf_file [index] > ras_file
 *
 * Compile :
 *
 *   cc hdf2ras.c rasutils.o utils.o -o hdf2ras -lpixrect -lhdf
 *
 * 				NO WARRANTY
 *  
 *  This software is distributed free of charge and is in the public domain.
 *  Anyone may use, duplicate or modify this program.  Thinking Machines
 *  Corporation does not restrict in any way the use of this software by
 *  anyone.
 *  
 *  Thinking Machines Corporation provides absolutely no warranty of any kind.
 *  The entire risk as to the quality and performance of this program is with
 *  you.  In no event will Thinking Machines Corporation be liable to you for
 *  damages, including any lost profits, lost monies, or other special,
 *  incidental or consequential damages arising out of the use of this program.
 * 
 * Jim Salem 9/26/89
 * Please keep this notice with the file.
 *
 * RCS: $Id: hdf2ras.c,v 2.0 90/08/01 11:04:02 salem Exp $
 *  $Log:	hdf2ras.c,v $
 * Revision 2.0  90/08/01  11:04:02  salem
 * Bump to next release, no changes
 * 
 * Revision 1.1  90/07/30  18:35:47  salem
 * Initial revision
 * 
 *
 *--------------------------------------------------------------------------*/

#include <stdio.h>

/*--------------------------------------------------------------------------*
 * Global Vars.
 *--------------------------------------------------------------------------*/

static
  char *filename;		/* The input file name */
static
  char *progname;		/* argv[0] */
static
  int index = 0;		/* The index */

/*--------------------------------------------------------------------------*
 * Utilities
 *--------------------------------------------------------------------------*/

extern void signal_hdf_error();
extern long strtol();

static
  int parse_uint (string)
char *string;
/* Returns -1 if error otherwise the integer */
{
  long ret;
  char *ptr;

  ret = strtol(string, &ptr, 10);
  if (ret < 0 || ptr != string + strlen(string))
    return -1;
  else
    return ret;
}

static
  void bad_usage ()
{
  fprintf(stderr,"Usage: %s hdf_file [index]\n\
  index identifies the particular image within the file (default 0)\n\
  Normally, you should pipe standard output into a rasterfile.\n", progname);
  exit (1);
}

/*--------------------------------------------------------------------------*
 * Main
 *--------------------------------------------------------------------------*/

void
  main (argc, argv)
int argc;
char **argv;
{
  progname = argv[0];

  /* argument parsing */
  if (argc < 2) bad_usage();
  filename = argv[1];
  if (argc == 3) index = parse_uint (argv[2]);
  if (argc > 3 || index < 0) bad_usage();

  if (! hdf_to_rasterfile (filename, index, stdout))
    signal_hdf_error(progname);

  exit(0);
}

    
