#ifdef RCSID
static char RcsId[] = "@(#)$Revision: 1.1 $";
#endif
/*
$Header: /pita/work/HDF/dev/RCS/test/annotations/file_ann_test.c,v 1.1 90/06/27 11:19:35 mfolk beta $

$Log:	file_ann_test.c,v $
 * Revision 1.1  90/06/27  11:19:35  mfolk
 * Initial revision
 * 
*/
/******************************************************************
*
* file_ann_test.c
*
* Example program: Storing and retrieving file IDs and descriptions.
*
* Opens an already-existing HDF file and stores four file IDs
* and one file description then closes the file.
*
* Reopens the same file and reads back the file IDs and descriptions.
*
*******************************************************************/

#include "df.h"
#include "dfan.h"

#define MAXLABLEN 80
#define MAXDESCLEN 1000
#define FIRST      1
#define NOTFIRST   0
main (argc, argv)
int argc;
char *argv[];
{
    DF *dfile;
    int i, ret, length;
    char outlabel[MAXLABLEN+1], inlabel[MAXLABLEN+1],
         outdescr[MAXDESCLEN+1], indescr[MAXDESCLEN+1];

    DFerror = DFE_NOERROR;

    if (argc != 2) {
        printf("Usage: %s filename\n",argv[0]);
        exit(1);
    }

    /* store four file IDs in file */

    if (NULL==(dfile = DFopen(argv[1], DFACC_WRITE, 0)) ) 
        fatalerror("Error opening file.");
    
    strcpy (outlabel, "Label # ");

    for (i=0; i<4; i++) {
        outlabel[7] = '0' + (char) i;
        if ( DFANaddfid(dfile, outlabel) < 0) 
        fatalerror("Error adding label to file.");
    }


    /* get and store description in file */

    getdescr(outdescr);

    if ( DFANaddfds(dfile, outdescr, strlen(outdescr)) < 0) 
        fatalerror("Error adding description.");


    DFclose(dfile);


    /* open file to read file IDs and file description */
    if (NULL==(dfile = DFopen(argv[1], DFACC_READ, 0)) ) 
        fatalerror("Error opening file.");

    /*  read all file IDs from file */

    printf("\n\n***Now reading label lengths and labels***\n");

    length = DFANgetfidlen(dfile, FIRST);
    if ( (ret = DFANgetfid(dfile,inlabel, MAXLABLEN, FIRST)) < 0 ) 
        fatalerror("Error reading label.");

    while ( ret >= 0) {
        printf("Label length: %d\tret: %d\tLabel: %s\n",length,ret,inlabel);
        length = DFANgetfidlen(dfile, NOTFIRST);
        ret = DFANgetfid(dfile,inlabel,MAXLABLEN, NOTFIRST);
    }
    if ( DFerror!=DFE_NOMATCH) 
        fatalerror("Error reading label."); 

    printf("\n***End of labels***\n");


    /* read description length and description from file */

    length = DFANgetfdslen(dfile, FIRST);
    printf("\n\nDescription length: %d\n", length);

    if ( (ret = DFANgetfds(dfile,indescr, MAXDESCLEN, FIRST)) < 0)
        fatalerror("Error reading description.");
    printf("\n***Just read description. ret: %d\nDescription: \n%s\n",
                                                            ret,indescr);
    printf("\n***End of description***\n");


    DFclose(dfile);
}

/************************************************************
* fatalerror: function to report fatal error and abort
*
***********************************************************/
    int
fatalerror(s)
char *s;
{
    printf("%s DFerror: %d.\nProgram aborted.\n", s, DFerror);
    exit(1);
}

/***********************************************************
*
* getdescr: function to put description in an array
*
***********************************************************/
    int
getdescr(outdescr)
char *outdescr;
{
    strcpy(outdescr, "Here is the loop used to write labels to this file:\n\n");
    strcat(outdescr, 
     "for (i=0; i<4; i++) {\n");
    strcat(outdescr, 
     " outlabel[7] = '0' + (char) i;\n");
    strcat(outdescr, 
     " if (DFANaddfileann(dfile,outlabel,strlen(outlabel),DFAN_LABEL)<0){\n");
    strcat(outdescr, 
     "   printf(\"Error adding label. DFerror: %d.\\nProgram aborted.\\n\",\n");
    strcat(outdescr, 
     "                                                           DFerror);\n");
    strcat(outdescr, 
     "       exit(1);\n");
    strcat(outdescr, 
     "   }\n");
    strcat(outdescr, 
     "}\n");
    strcat(outdescr, "\nThis is the end of the description.\n\n");
}
