(*^

::[paletteColors = 128; 
	fontset = title, "Geneva", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Geneva", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Geneva", 14, L2, center, bold, nohscroll;
	fontset = section, "Geneva", 14, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Geneva", 12, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Geneva", 10, L2, bold, nohscroll, whiteBox;
	fontset = text, "Geneva", 12, L2, nohscroll;
	fontset = smalltext, "Geneva", 10, L2, nohscroll;
	fontset = input, "Courier", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R65535, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Geneva", 10, L2, italic, B65535, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Geneva", 10, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "New York", 12, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Maps of Complex Functions
:[font = text; inactive; ]
This example comes from Chapter 1.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

;[s]
3:0,0;67,1;93,0;470,-1;
2:2,14,10,Geneva,0,10,0,0,0;1,14,10,Geneva,2,10,0,0,0;
:[font = section; inactive; startGroup; Cclosed; ]
Examples
:[font = subsection; inactive; startGroup; Cclosed; ]
Cartesian Maps
:[font = text; inactive; ]
Identity function
:[font = input; ]
CartesianMap[ Identity, {-Pi/2, Pi/2, Pi/14},
	{-1, 1, 2/10} ];
:[font = text; inactive; ]
Sine function
:[font = input; ]
CartesianMap[ Sin, {-Pi/2, Pi/2, Pi/14}, {-1, 1, 2/10} ];
:[font = text; inactive; ]
Exponential function
:[font = input; ]
CartesianMap[ Exp, {-1, 1, 0.2}, {-2, 2, 0.2} ];
:[font = text; inactive; ]
Zeta function
:[font = input; endGroup; ]
CartesianMap[ Zeta, {0.1, 0.9}, {0, 20},
	PlotPoints -> 25 ];
:[font = subsection; inactive; startGroup; Cclosed; ]
Polar Maps
:[font = text; inactive; ]
polar coordinate lines
:[font = input; ]
PolarMap[ Identity, {0, 1, 0.1}, {0, 2Pi, 2Pi/24} ];
:[font = text; inactive; ]
Logarithm
:[font = input; ]
PolarMap[ Log, {0.1, 10, 0.5}, {-3, 3, 0.15} ];
:[font = text; inactive; ]
Complex conjugate
:[font = input; ]
PolarMap[ 1/Conjugate[#]&,
	{0.1, 5.1, 0.5}, {-Pi, Pi, 2Pi/24} ];
:[font = text; inactive; ]
Square Root
:[font = input; ]
PolarMap[ Sqrt, {1}, {-Pi - 0.0001, Pi},
	PlotPoints -> 25 ];
:[font = text; inactive; ]
Moebius transform
:[font = input; ]
PolarMap[ (# - I)/(2# - 2)&, {4}, {-Pi, Pi, 2Pi/25} ];
:[font = text; inactive; ]
Exponential function
:[font = input; endGroup; ]
PolarMap[Exp, {1}, {-Pi, Pi},
		PlotPoints->25, Axes->None, Framed->True];
:[font = subsection; inactive; startGroup; Cclosed; ]
Testing Singularities
:[font = text; inactive; ]
This is from page 28.
:[font = input; ]
<< ComplexTest.m
:[font = input; ]
CartesianMap[ f, {-2, 2, 1/3}, {-2, 2, 1/3},
	Axes->None ];
:[font = input; endGroup; endGroup; ]
CartesianMap[ 1/Conjugate[#]&,
	{-2, 2, 0.2}, {-2, 2, 0.2} ];
:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)

BeginPackage["RMPackages`ComplexMap`"]
(*
:[font = input; initialization; ]
*)
CartesianMap::usage = "CartesianMap[f, {x0, x1, (dx)}, {y0, y1, (dy)}, options...] plots
	the image of the cartesian coordinate lines under the function f.
	The default values of dx and dy are chosen so that the number of lines
	is equal to the value of the option PlotPoints of Plot3D[]"
(*
:[font = input; initialization; ]
*)
PolarMap::usage = "PolarMap[f, {r0:0, r1, (dr)}, {phi0, phi1, (dphi)}, options...] plots
	the image of the polar coordinate lines under the function f.
	The default values of dr and dphi are chosen so that the number of lines
	is equal to the value of the option PlotPoints of Plot3D[].
	The default for the phi range is {0, 2Pi}."
(*
:[font = input; initialization; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; ]
*)
huge = 10.0^6
(*
:[font = input; initialization; ]
*)
SplitLine[vl_] :=
	Block[{vll, pos, linelist = {}, low, high},
		vll = If[NumberQ[#], #, Indeterminate]& /@ vl;
		pos = Flatten[ Position[vll, Indeterminate] ];
		pos = Union[ pos, {0, Length[vll]+1} ];
		Do[ low = pos[[i]]+1;
		    high = pos[[i+1]]-1;
		    If[ low < high, AppendTo[linelist, Take[vll, {low, high}]] ],
		   {i, 1, Length[pos]-1}];
		linelist
	]
(*
:[font = input; initialization; ]
*)
MakeLines[points_] :=
	Block[{lines, newpoints},
		newpoints = points /.
			{ z_?NumberQ :> huge z/Abs[z] /; Abs[z] > huge,
			  z_?NumberQ :> 0.0 /; Abs[z] < 1/huge,
			  DirectedInfinity[z_] :> huge z/Abs[z] };
		lines = Join[ newpoints, Transpose[newpoints] ];
		lines = Flatten[ SplitLine /@ lines, 1 ];
		lines = Map[ {Re[#], Im[#]}&, lines, {2} ];
		lines = Map[ Line, lines ];
		Graphics[lines]
	]
(*
:[font = input; initialization; ]
*)
FilterOptions[ command_Symbol, opts___ ] :=
	Block[{keywords = First /@ Options[command]},
		Sequence @@ Select[ {opts}, MemberQ[keywords, First[#]]& ]
	]
(*
:[font = input; initialization; ]
*)
CartesianMap[ f_, {x0_, x1_, dx_:Automatic}, {y0_, y1_, dy_:Automatic}, opts___ ] :=
	Block[ {x, y, points, plotpoints, ndx=N[dx], ndy=N[dy]},
		plotpoints = PlotPoints /. {opts} /. Options[Plot3D];
		If[ dx === Automatic, ndx = N[(x1-x0)/(plotpoints-1)] ];
		If[ dy === Automatic, ndy = N[(y1-y0)/(plotpoints-1)] ];
		points = Table[ N[f[x + I y]],
			{x, x0, x1, ndx}, {y, y0, y1, ndy} ];
		Show[ MakeLines[points], FilterOptions[Graphics, opts],
			AspectRatio->Automatic, Axes->Automatic ]
	] /; NumberQ[N[x0]] && NumberQ[N[x1]] && NumberQ[N[y0]] && NumberQ[N[y1]]
		 (NumberQ[N[dx]] || dx === Automatic) &&
		 (NumberQ[N[dy]] || dy === Automatic)
(*
:[font = input; initialization; ]
*)
PolarMap[ f_, {r0_:0, r1_, dr_:Automatic}, {phi0_, phi1_, dphi_:Automatic}, opts___ ] :=
	Block[ {r, phi, points, plotpoints, ndr=dr, ndphi=dphi},
		plotpoints = PlotPoints /. {opts} /. Options[Plot3D];
		If[ dr === Automatic, ndr = N[(r1-r0)/(plotpoints-1)] ];
		If[ dphi === Automatic, ndphi = N[(phi1-phi0)/(plotpoints-1)] ];
		points = Table[ N[f[r Exp[I phi]]],
			{r, r0, r1, ndr}, {phi, phi0, phi1, ndphi} ];
		Show[ MakeLines[points], FilterOptions[Graphics, opts],
			AspectRatio->Automatic, Axes->Automatic ]
	] /; NumberQ[N[r0]] && NumberQ[N[r1]] && NumberQ[N[phi0]] && NumberQ[N[phi1]]
		 (NumberQ[N[dr]] || dr === Automatic) &&
		 (NumberQ[N[dphi]] || dphi === Automatic)
(*
:[font = input; initialization; ]
*)
PolarMap[ f_, rRange_List, opts___Rule ] :=
	PolarMap[ f, rRange, {0, 2Pi}, opts ]
(*
:[font = input; initialization; ]
*)
End[ ]
(*
:[font = input; initialization; ]
*)
Protect[CartesianMap, PolarMap]
(*
:[font = input; initialization; endGroup; ]
*)
EndPackage[ ]
(*
^*)