/**************************************************
 * Module: xcalls.c
 * Purpose: Xlib, Xtoolkit, and Xmotif calls
 * Invokes: 
 * Contents:
 *  CBExit: exits X HDF Browser
 *  CBGetAnnDesc: if current tag is a DIA, then get the annotation length from
 *                the HDF file.  Call CBReadFile to read the annotation.
 * Remarks:
 **************************************************/
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: xcalls.c,v 1.3 93/11/05 10:57:37 gbourhis Exp $";
#endif
/* $Log:	xcalls.c,v $
 * Revision 1.3  93/11/05  10:57:37  gbourhis
 * Some changes in CBGetType().
 * 
 */

#include "hbox.h"
#include "help.h"         /* XHDF Browser help string */

#define cjhDEBUG 1

struct func_rec {
	void (*LoadFunc)();
	void (*SendFunc)();
	void (*CancelFunc)();
};

/****************************************
 * CBCancelHelpAll: cancel help window
 ****************************************/
void CBCancelHelpAll(w, client_data, call_data)
     Widget  w;    /* exit button widget ID on help window */
     void    *client_data;
     void    *call_data;
{
  Arg   wargs[3];
  ctxt_ptr c;
  int n;

  n = 0;
  XtSetArg(wargs[n], XmNuserData, &c); n++;
  XtGetValues(w, wargs, n);

  XtPopdown(c->helpShell);
}


/****************************************
 * CBGetHelpAll:  get help on all browser
 *                capabilities
 * Inputs:  w:  help widget ID of top level window
 *          client_data: extra info I need (NULL)
 *          call_data:   callback data
 ****************************************/
void CBGetHelpAll(w, client_data, call_data)
     Widget   w;
     void     *client_data;
     void     *call_data;
{
  Arg      wargs[3];
  ctxt_ptr c;
  int      n;

  n = 0;
  XtSetArg(wargs[n], XmNuserData, &c); n++;
  XtGetValues(w, wargs, n);
  showHelp(c, helpALL, "HBoX Browse Help");

}


/****************************************
 * CBGetHelpAll:  get help on contents
 *                     window
 * Inputs:  w: contents help widget ID
 *          client_data: extra info I need ( NULL )
 *          call_data:   callback data
 ****************************************/
void CBGetHelpContents(w, client_data, call_data)
     Widget   w;
     void     *client_data;
     void     *call_data;
{
  Arg      wargs[3];
  ctxt_ptr c;
  int      n;

  n = 0;
  XtSetArg(wargs[n], XmNuserData, &c); n++;
  XtGetValues(w, wargs, n);
  showHelp(c, helpCONT, "Contents Help");

}


/**********************************************************
 * CBGetHelpEditor:  get help on annotation editor
 * Inputs:  w:  help widget ID of label (annotation) editor
 *          client_data: extra info I need ( NULL )
 *          call_data:   callback data
 **********************************************************/
void CBGetHelpEditor(w, client_data, call_data)
     Widget   w;
     void     *client_data;
     void     *call_data;
{
  char     *helpttl;         /* help window title */
  Arg   wargs[3];
  ctxt_ptr c;
  int n;

  n = 0;
  XtSetArg(wargs[n], XmNuserData, &c); n++;
  XtGetValues(w, wargs, n);

  if (c->editType == DFTAG_DIL)
    helpttl = "Label Editor Help";
  else
    helpttl = "Annotation Editor Help";

  showHelp(c, helpEDIT, helpttl);
}


/****************************************
 * showHelp: show help on all browser 
 *            capabilities
 * Inputs:  *buf: pointer to help string
 *          helptitle: title for help window
 ****************************************/
void showHelp(c, buf, helptitle)
     ctxt_ptr c;
     char *buf;
     char *helptitle;
{
  Arg      wargs[20];           /* widget resource arguments */
  Cardinal n;                   /* number of resource arguments to list */  

  /*
   * Map help window
   */
  XtPopup(c->helpShell, XtGrabNone);
  RAISE(c->helpShell);

  n = 0;
  XtSetArg(wargs[n], XmNtitle, helptitle); n++;
  XtSetValues(c->helpShell, wargs, n);

  XmTextSetTopCharacter(c->helpText, 0);
  XmTextSetString(c->helpText, buf);      /* display text */

}  

/****************************************************
 * CBSendBuf: send buffer of previously 'load'ed tags
 ****************************************************/
void CBSendBuf(w, client_data, call_data)
     Widget   w;
     void (*client_data)();
     caddr_t call_data;
{
  Arg   wargs[3];
  ctxt_ptr c;
  int n;

  n = 0;
  XtSetArg(wargs[n], XmNuserData, &c); n++;
  XtGetValues(w, wargs, n);

#if DEBUG 
  printf("--------- context: %d ---------\n", c);
  printf("in CBSendBuf\n");
#endif

  if(!c->buf_size) {
    printf("No items in the buffer\n");
    return;
  }

  if(client_data) {
    void (*tmp)();
    tmp = (void (*) ()) client_data;
    tmp(c->buf_size, c->buffer);
  }

  /*
   * Allocate a new buffer for storing tags
   */
  c->buffer = (tag_ref_ptr) calloc(BUFFER, sizeof(tag_ref));
  c->buf_size = 0;

} /* CBSendBuf */
 

/********************************************
 * CBSendSel: send selected TAG(s) and REF(s)
 ********************************************/
void CBSendSel(w, client_data, call_data)
     Widget   w;
     void (*client_data)();
     caddr_t call_data;
{
  Cardinal n;
  Arg   wargs[3];
  ctxt_ptr c;
  int i, lst, pos;
  tag_ref_ptr tr;
  int   *position_list;
  int   position_count = 0;

  n = 0;
  XtSetArg(wargs[n], XmNuserData, &c); n++;
  XtGetValues(w, wargs, n);

#if DEBUG 
  printf("--------- context: %d ---------\n", c);
  printf("in CBSendSel\n");
#endif

  lst = 0;

  if (!XmListGetSelectedPos(c->list[lst], &position_list, &position_count)) {
    if(position_count == 0) {
      printf("No items selected\n");
    }
    else {
      printf ("CBSendSel: error getting selections\n");
    }
    return;
  }

  if(position_count == 0) {
    printf("No items selected\n");
    return;
  }

  tr = (tag_ref_ptr) malloc(position_count * sizeof(tag_ref));
  for (i=0; i<position_count; i++)
  {
	pos = position_list[i];
	tr[i].tag = c->index[lst][(pos - 1)].tag;
	tr[i].ref = c->index[lst][(pos - 1)].ref;
  }
  free((char *)position_list);

  if(client_data) {
    void (*tmp)();
    tmp = (void (*) ()) client_data;
    tmp(position_count, tr);
  }

} /* CBSendSel */


/********************************************
 * CBSendOne: send selected item double clicked on
 ********************************************/
void CBSendOne(w, client_data, call_data)
     Widget   w;
     caddr_t     *client_data;
     caddr_t     *call_data;
{
	XmListCallbackStruct *Lcb = (XmListCallbackStruct *)call_data;
	struct func_rec *funcs = (struct func_rec *)client_data;
	int i, indx, tag, ref, pos;
	Cardinal n;
	Arg wargs[3];
	ctxt_ptr c;
	tag_ref_ptr tr;

	if (Lcb->reason != XmCR_DEFAULT_ACTION)
	{
		return;
	}

	n = 0;
	XtSetArg(wargs[n], XmNuserData, &c); n++;
	XtGetValues(w, wargs, n);

	pos = Lcb->item_position;

	/* 
	 *  get TAG and REF # of selected entry from List
	 */
	tag = 0;
	for(i = 0; i < NUM_LIST; i++) {
		if (w == c->list[i]) {
			indx = i;
			tag = c->index[i][(pos - 1)].tag;
			ref = c->index[i][(pos - 1)].ref;
		}
	}

	if (tag == 0) {
		printf("No items selected\n");
		return;
	}

	/* Unmanage list before sending */
	XtPopdown(c->hdfShell);

	/* send the list off */
	tr = (tag_ref_ptr) malloc(sizeof(tag_ref));
	tr->tag = tag;
	tr->ref = ref;

	if((funcs)&&(funcs->SendFunc)) {
		void (*tmp)();
		tmp = (void (*) ()) (funcs->SendFunc);
		tmp(1, tr);
	}

	/* Close down the browser */

	XtDestroyWidget(c->hdfShell);

        Vend(c->f);
        Hclose(c->f);
        HDfreespace(c);

	if((funcs)&&(funcs->CancelFunc)) {
		void (*tmp)();
		tmp = (void (*) ()) (funcs->CancelFunc);
		tmp();
	}
}


/*************************************************************
 * CBLoadBuf: load  selected TAG(s) and REF(s) into the buffer
 *************************************************************/
void  CBLoadBuf(w, client_data, call_data)
     Widget   w;
     void (*client_data)();
     caddr_t call_data;
{
  Arg   wargs[3];
  ctxt_ptr c;
  int n, i;
  int t, r;

  n = 0;
  XtSetArg(wargs[n], XmNuserData, &c); n++;
  XtGetValues(w, wargs, n);

  if(!c->selection[0]) {
    printf("No items selected\n");
    return;
  }

  if(c->buf_size == BUFFER -1) {
    printf("Buffer is full\n");
    return;
  }

  /* find inner-most list with an active selection */
  i = 0;
  while((i < NUM_LIST - 1) && (c->selection[i + 1]))
    i++;

#if DEBUG
  printf("Loading an item selected from list %d position %d\n", i, c->selection[i]);
#endif

  /* send the list off */
  t = c->buffer[c->buf_size].tag = c->index[i][c->selection[i] - 1].tag;
  r = c->buffer[c->buf_size].ref = c->index[i][c->selection[i] - 1].ref;
  c->buf_size++;

#if DEBUG
  printf("Loaded %d %d into location %d\n", t, r, c->buf_size - 1);
#endif

  if(client_data) {
    void (*tmp)();
    tmp = (void (*) ()) client_data;
    tmp(c->buffer[c->buf_size - 1]);
  }

} /* CBLoadBuf */

/*********************************************************
 * CBClearBuf: Remove all elements currently in the buffer 
 *********************************************************/
void  CBClearBuf(w, client_data, call_data)
     Widget   w;
     void     *client_data;
     void     *call_data;
{
  Arg   wargs[3];
  ctxt_ptr c;
  int n;

  n = 0;
  XtSetArg(wargs[n], XmNuserData, &c); n++;
  XtGetValues(w, wargs, n);

  if(!c->buf_size) {
    /* buffer is already empty */
    return;
  }

  /*
   * Allocate a new buffer for storing tags
   */
  free(c->buffer);
  c->buffer = (tag_ref_ptr) calloc(BUFFER, sizeof(tag_ref));
  c->buf_size = 0;

} /* CBClearBuf */

/****************************************
 * CBReset: reset text file to saved text
 ****************************************/
void CBReset(w, client_data, call_data)
     Widget    w;
     void      *client_data;
     void      *call_data;
{
  XmTextPosition last;
  Arg   wargs[3];
  ctxt_ptr c;
  int n;

  n = 0;
  XtSetArg(wargs[n], XmNuserData, &c); n++;
  XtGetValues(w, wargs, n);

  c->firstEdit = TRUE;
  XmTextSetTopCharacter(c->textedit, 0);
  XmTextSetString(c->textedit, c->backup_text);
  last = XmTextGetLastPosition(c->textedit);
  XmTextSetInsertionPosition(c->textedit, last);

} /* CBReset */


/******************************************************
 * Create a label for the current selection
 *****************************************************/
void CBCreateLabel(w, client_data, call_data)
     Widget  w;
     int     client_data;
     void    *call_data;
{
  Arg wargs[5];
  int n;
  ctxt_ptr c;
  int ptag, pref;  /* tag / ref of thing label is for */
  int index;

  n = 0;
  XtSetArg(wargs[n], XmNuserData, &c); n++;
  XtGetValues(w, wargs, n);

  /* put the editor window up */
  if (c->editShellMapped) {
    RAISE(c->editShell);
    if(c->textChanged) {
      XtManageChild(c->errorBox);
      return;
    } else {
      XtDestroyWidget(c->editLabel);
    }
  } else {
    c->editShellMapped = 1;
    XtPopup(c->editShell, XtGrabNone);
  }

  /* assume the last selected thing is what we want the annotation on */
  index = 0;
  while((index < NUM_LIST) && c->selection[index])
    index++;
  
  ptag = c->ptag[index];
  pref = c->pref[index];

#if DEBUG
  printf("index %d ,  ptag %d  pref %d\n", index, ptag, pref);
#endif

  /* start the editing session */
  annRead(c, client_data, 0, NULL, ptag, pref);
  
} /* CreateLabel */

/*******************************************************
 * CBGetType: get list option type; prepare to list desc
 *******************************************************/
void CBGetType(w, client_data, call_data)
     Widget    w;
     int       client_data;
     void      *call_data;
{ 
  ctxt_ptr c;
  int n, i;
  Arg wargs[5];
  XmToggleButtonCallbackStruct *xmCallData = (XmToggleButtonCallbackStruct *)
    call_data;

  n = 0;
  XtSetArg(wargs[n], XmNuserData, &c); n++;
  XtGetValues(w, wargs, n);

  switch(client_data) {
  case ALL:
    for(i = 0; i < 5; i++)
      XmToggleButtonSetState(c->button[i], (Boolean) False, (Boolean) False);

    if (xmCallData->set) {
      c->list_type = ALL;
      XmToggleButtonSetState(c->button[5], (Boolean) False, (Boolean) False);
    }
    else {
      c->list_type = GROUP;
      XmToggleButtonSetState(c->button[5], (Boolean) True, (Boolean) False);
    }
    break;
  case GROUP:
    for(i = 0; i < 5; i++) 
      XmToggleButtonSetState(c->button[i], (Boolean) False, (Boolean) False);

    if (xmCallData->set) {
      c->list_type = GROUP;
      XmToggleButtonSetState(c->button[6], (Boolean) False, (Boolean) False);
    }
    else {
      c->list_type = ALL;
      XmToggleButtonSetState(c->button[6], (Boolean) True, (Boolean) False);
    }
    break;
  default:
    if((c->list_type == ALL) || (c->list_type == GROUP)) {
#if DEBUG
      printf("zeroing button 5\n");
      printf("zeroing button 6\n");
#endif
      XmToggleButtonSetState(c->button[5], (Boolean) False, (Boolean) False);
      XmToggleButtonSetState(c->button[6], (Boolean) False, (Boolean) False);
      c->list_type = 0;
    }
    c->list_type ^= client_data;
    break;
  }
  

#if DEBUG
  printf("before getDesc: [ ");

  for(i = 0; i < 7; i++) {
    printf("%d ", XmToggleButtonGetState(c->button[i]));
  }
  printf("]\n");
#endif

  getDesc(c); 
#if DEBUG
  printf("CBGetType: done type = %d\n", c->list_type);

  printf("after getDesc: [ ");

  for(i = 0; i < 7; i++) {
    printf("%d ", XmToggleButtonGetState(c->button[i]));
  }
  printf("]\n");
#endif

}


/*
**
**
*/
void CBClose(w, client_data, call_data)
     Widget w;
     void (*client_data)();
     caddr_t call_data;
{

  int n;
  Arg   wargs[3];
  ctxt_ptr c;


  n = 0;
  XtSetArg(wargs[n], XmNuserData, &c); n++;
  XtGetValues(w, wargs, n);

  XtDestroyWidget(c->hdfShell);
  XtDestroyWidget(c->listShell);
  XtDestroyWidget(c->helpShell);
  XtDestroyWidget(c->editShell);

  if(client_data) {
    void (*tmp)();
    tmp = (void (*) ()) client_data;
    tmp();
  }

} /* CBclose */


/***************************************************
 * CBrefresh:  REfresh the windows by reading from
 *             the file.  This is helpful for echoing
 *             changes in annotations / labels
 ***************************************************/
void CBRefresh(w, client_data, call_data)
     Widget  w;
     void    *client_data;
     void    *call_data;
{
  Arg   wargs[3];
  ctxt_ptr c;
  int n;

  n = 0;
  XtSetArg(wargs[n], XmNuserData, &c); n++;
  XtGetValues(w, wargs, n);

  updateDesc(c);
  getDesc(c);
  
} /* CBrefresh */

/*********************************************************************
 * CBTextValueChanged:  User has changed the text in the edit window
 *********************************************************************/
void CBTextValueChanged(w, client_data, call_data)
     Widget  w;         
     void    *client_data;
     void    *call_data;
{
  Arg   wargs[3];
  ctxt_ptr c;
  int n;

  n = 0;
  XtSetArg(wargs[n], XmNuserData, &c); n++;
  XtGetValues(w, wargs, n);

  if(c->firstEdit) {
    c->firstEdit = FALSE;
    c->textChanged = FALSE;
  } else {
    c->textChanged = TRUE;
  }

} /* CBTextValueChanged */



