#include "easy.h"
#include "easydefs.h"

#include <stdio.h>

static void error_and_out(nresult, ncnt)
     int nresult;
     int ncnt;
{
  fprintf(stderr,
  "gcol#%d(@%d): Result buffer too small (=%d) to accomodate collect data (=%d)\n",
	  DATATYPE,ME,nresult,ncnt);
  killproc(ME);
}

#define FUNC     gb1col
#define TYPE     char
#define PACK     pvm_pkbyte
#define UNPACK   pvm_upkbyte
#include "gcol.h"

#define FUNC     gi2col
#define TYPE     short
#define PACK     pvm_pkshort
#define UNPACK   pvm_upkshort
#include "gcol.h"

#define FUNC     gi4col
#define TYPE     int
#define PACK     pvm_pkint
#define UNPACK   pvm_upkint
#include "gcol.h"

#define FUNC     gr4col
#define TYPE     float
#define PACK     pvm_pkfloat
#define UNPACK   pvm_upkfloat
#include "gcol.h"

#define FUNC     gr8col
#define TYPE     double
#define PACK     pvm_pkdouble
#define UNPACK   pvm_upkdouble
#include "gcol.h"

#define MULTIP   2*
#define FUNC     gz8col
#define TYPE     float
#define PACK     pvm_pkcplx
#define UNPACK   pvm_upkcplx
#include "gcol.h"

#define MULTIP   2*
#define FUNC     gz16col
#define TYPE     double
#define PACK     pvm_pkdcplx
#define UNPACK   pvm_upkdcplx
#include "gcol.h"


int gcol(data, ndata, result, nresult)
     void *data; 
     int ndata;
     void *result; 
     int nresult;
{
  int ncnt = 0;

  if (ME != HOSTID) { /* Exclude the HOST */

#ifdef PICL
    if (logfp) {
      if (ME==0) tracemsg("gcol()");
      SETIDLETIME();
      TRACEF(20,-4,MSG_COL,0);
    }
#endif /* PICL */

    switch (DATATYPE) {
    case BYTE1:
      ncnt = gb1col(data,ndata,result,nresult);
      break;
    case INTEGER2:
      ncnt = gi2col(data,ndata,result,nresult);
      break;
    case INTEGER4:
      ncnt = gi4col(data,ndata,result,nresult);
      break;
    case REAL4:
      ncnt = gr4col(data,ndata,result,nresult);
      break;
    case REAL8:
      ncnt = gr8col(data,ndata,result,nresult);
      break;
    case COMPLEX8:
      ncnt = gz8col(data,ndata,result,nresult);
      break;
    case COMPLEX16:
      ncnt = gz16col(data,ndata,result,nresult);
      break;
    default:
      fprintf(stderr,
	      "gcol(@%d): Not implemented with data type# %d\n",
	      ME,DATATYPE);
      killproc(ME);
      break;
    }

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(21,-4,MSG_COL,0);
      UPDATEIDLETIME();
    }
#endif /* PICL */

  }

  return ncnt;
}

