#include "easy.h"
#include "easydefs.h"

int setdatatype(newvalue)
     int newvalue;
{
  if (not_attached) attachproc();
  {
    int old = DATATYPE;
    DATATYPE = newvalue;
    return old;
  }
}

int getdatatype()
{
  return DATATYPE;
}

int setstride(newvalue)
     int newvalue;
{
  if (not_attached) attachproc();
  {
    int old = STRIDE;
    STRIDE = newvalue;
    return old;
  }
}

int getstride()
{
  return STRIDE;
}

int getmeshdim(nx, ny, nz)
     int *nx;
     int *ny; 
     int *nz;
{
  if (nx) *nx = NX;
  if (ny) *ny = NY;
  if (nz) *nz = NZ;
  return NUMNODES;
}

int getxyz(x, y, z)
     int *x;
     int *y;
     int *z;
{
  if (x) *x = X;
  if (y) *y = Y;
  if (z) *z = Z;
  return ME;
}

int getcluster()
{
  return  active_cluster_id;
}

int setcluster(id)
     int id;
{
  int old = active_cluster_id;

  if (not_attached) attachproc();

  if (id >= 0 && id < MAXCLUSTERS) {
    active_cluster_id = id;
    cluster_id[id] = 1;
    LocalMPP_Info = &AllMPP_Info[id];
    CLUSTERID = id;
  }
  else if (id == NOCARE) { /* Find the next free cluster id */
    int i;
    
    if (NUMNODES == 0) {
      setcluster(old);
      return old;
    }

    for (i=0; i<MAXCLUSTERS; i++) {
      if (cluster_id[i] == 0) {
	setcluster(i);
	return old;
      }
    }
    fprintf(stderr,
	    "setcluster: Cluster space exhausted. Increase current MAXCLUSTERS = %d\n",
	    MAXCLUSTERS);
    killproc(ME);
  }
  else {
    fprintf(stderr,
	    "setcluster: Invalid cluster id %d. Must be >=0 & < MAXCLUSTERS=%d\n",
	    id,MAXCLUSTERS);
    killproc(ME);
  }
  
  return old;
}


int getload(load) /* Brute force method to obtain {1,5,15} minutes average load */
     double *load;
{
  if (load) {
    char *cmd=
      "uptime | sed 's/load average:/#/g' | awk -F# '{print $2}'";
    FILE *fp = popen(cmd,"r");
    
    load[0] = load[1] = load[2] = 0.0;
  
    if (fp) {
      fscanf(fp,"%lf, %lf, %lf",&load[0],&load[1],&load[2]);
      pclose(fp);
    }
  }
  return 0;
}
