SUBROUTINE MySolver(Model, Solver, dt, Transient)
  Use DefUtils
  IMPLICIT NONE
  TYPE(Solver_t) :: Solver
  TYPE(Model_t) :: Model
  REAL(KIND=dp) :: dt
  LOGICAL :: Transient

  TYPE(Mesh_t), POINTER :: Mesh
  TYPE(Element_t), POINTER :: Element
  TYPE(ValueList_t), POINTER :: Material
  REAL(KIND=dp), ALLOCATABLE :: MyParameter(:)
  LOGICAL :: AllocationsDone = .FALSE.
  LOGICAL :: Found
  INTEGER :: N
  SAVE MyParameter, AllocationsDone

  IF(.NOT.AllocationsDone) THEN
     Mesh => GetMesh(Solver)
     N = Mesh % MaxElementNodes
     ALLOCATE(MyParameter(N))
     AllocationsDone = .TRUE.
  END IF

  N = GetNofActive(Solver)
  IF(N < 1) CALL Fatal("MySolver", "No elements in the mesh")

  Element => GetActiveElement(3)
  N = GetElementNofNodes(Element)
  
  Material => GetMaterial(Element)
  IF(.NOT.ASSOCIATED(Material)) CALL Fatal("MySolver", "No material block")

  MyParameter(1:N) = GetReal(Material, "MyParameter", Found)
  IF(.NOT.Found) CALL Fatal("MySolver", "MyParameter not found")
  
  PRINT *, "Element 3:"
  PRINT *, "Node indices:", Element % NodeIndexes(1:N)
  PRINT *, "Nodal values of MyParameter:", MyParameter(1:N)

END SUBROUTINE MySolver
