      PROGRAM P54
C
C      PROGRAM 5.4 PLANE STRAIN OF AN ELASTIC
C      SOLID USING 8-NODE QUADRILATERAL ELEMENTS
C
C
C      ALTER NEXT LINE TO CHANGE PROBLEM SIZE
C
      PARAMETER (IKB1=100,IKB2=35,ILOADS=100,INF=100)
C
      REAL AA
      REAL BB
      REAL E
      REAL V
      REAL DET
      REAL QUOT
      REAL DEE(3,3),SAMP(4,2),COORD(8,2),JAC(2,2),JAC1(2,2),DER(2,8),
     +     DERIV(2,8),BEE(3,16),DBEE(3,16),BTDB(16,16),KM(16,16),
     +     ELD(16),EPS(3),SIGMA(3),BT(16,3),FUN(8),KB(IKB1,IKB2),
     +     LOADS(ILOADS)
      INTEGER NF(INF,2),G(16)
      DATA IDEE,IBEE,IDBEE,IH/4*3/,IDOF,IBTDB,IBT,IKM/4*16/
      DATA IJAC,IJAC1,NODOF,IT,IDER,IDERIV/6*2/,ICOORD,NOD/2*8/
      DATA ISAMP/4/
C
C      INPUT AND INITIALISATION
C
      READ (5,FMT=*) NXE,NYE,N,IW,NN,NR,NGP,AA,BB,E,V
      CALL READNF(NF,INF,NN,NODOF,NR)
      IWP1 = IW + 1
      CALL NULL(KB,IKB1,N,IWP1)
      CALL FMDEPS(DEE,IDEE,E,V)
      CALL GAUSS(SAMP,ISAMP,NGP)
C
C      ELEMENT STIFFNESS INTEGRATION AND ASSEMBLY
C
      DO 10 IP = 1,NXE
          DO 10 IQ = 1,NYE
              CALL GEOM8X(IP,IQ,NXE,AA,BB,COORD,ICOORD,G,NF,INF)
              CALL NULL(KM,IKM,IDOF,IDOF)
              DO 20 I = 1,NGP
                  DO 20 J = 1,NGP
                      CALL FMQUAD(DER,IDER,FUN,SAMP,ISAMP,I,J)
                      CALL MATMUL(DER,IDER,COORD,ICOORD,JAC,IJAC,IT,NOD,
     +                            IT)
                      CALL TWOBY2(JAC,IJAC,JAC1,IJAC1,DET)
                      CALL MATMUL(JAC1,IJAC1,DER,IDER,DERIV,IDERIV,IT,
     +                            IT,NOD)
                      CALL NULL(BEE,IBEE,IH,IDOF)
                      CALL FORMB(BEE,IBEE,DERIV,IDERIV,NOD)
                      CALL MATMUL(DEE,IDEE,BEE,IBEE,DBEE,IDBEE,IH,IH,
     +                            IDOF)
                      CALL MATRAN(BT,IBT,BEE,IBEE,IH,IDOF)
                      CALL MATMUL(BT,IBT,DBEE,IDBEE,BTDB,IBTDB,IDOF,IH,
     +                            IDOF)
                      QUOT = DET*SAMP(I,2)*SAMP(J,2)
                      CALL MSMULT(BTDB,IBTDB,QUOT,IDOF,IDOF)
   20         CALL MATADD(KM,IKM,BTDB,IBTDB,IDOF,IDOF)
   10 CALL FORMKB(KB,IKB1,KM,IKM,G,IW,IDOF)
C
C      EQUATION SOLUTION
C
      CALL CHOLIN(KB,IKB1,N,IW)
      CALL NULVEC(LOADS,N)
      READ (5,FMT=*) NL, (K,LOADS(K),I=1,NL)
      CALL CHOBAC(KB,IKB1,LOADS,N,IW)
      CALL PRINTV(LOADS,N)
C
C      RECOVER STRAINS AND STRESSES AT ELEMENT CENTRES
C
      NGP = 1
      CALL GAUSS(SAMP,ISAMP,NGP)
      DO 30 IP = 1,NXE
          DO 30 IQ = 1,NYE
              CALL GEOM8X(IP,IQ,NXE,AA,BB,COORD,ICOORD,G,NF,INF)
              DO 40 M = 1,IDOF
                  IF (G(M).EQ.0) ELD(M) = 0.
   40         IF (G(M).NE.0) ELD(M) = LOADS(G(M))
              DO 30 I = 1,NGP
                  DO 30 J = 1,NGP
                      CALL FMQUAD(DER,IDER,FUN,SAMP,ISAMP,I,J)
                      CALL MATMUL(DER,IDER,COORD,ICOORD,JAC,IJAC,IT,NOD,
     +                            IT)
                      CALL TWOBY2(JAC,IJAC,JAC1,IJAC1,DET)
                      CALL MATMUL(JAC1,IJAC1,DER,IDER,DERIV,IDERIV,IT,
     +                            IT,NOD)
                      CALL NULL(BEE,IBEE,IH,IDOF)
                      CALL FORMB(BEE,IBEE,DERIV,IDERIV,NOD)
                      CALL MVMULT(BEE,IBEE,ELD,IH,IDOF,EPS)
                      CALL MVMULT(DEE,IDEE,EPS,IH,IH,SIGMA)
                      CALL PRINTV(EPS,IH)
                      CALL PRINTV(SIGMA,IH)
   30 CONTINUE
      STOP

      END
