      SUBROUTINE CFFT2D2 (IS, M, M1, N, X, W, IP)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C   PERFORMS COMPLEX RADIX 2 FFTS ON THE SECOND DIMENSION OF THE 2-D ARRAY X
C   D H BAILEY  11/15/84
C
      COMPLEX X(M1,N), W(N), CT, CX
      INTEGER IP(2,N)
      DATA PI/3.141592653589793/
C
C   IF  IS = 0  THEN INITIALIZE ONLY
C
      N2 = N / 2
      IF (IS .EQ. 0)  THEN
        DO 100 I = 1, N2
          T = 2. * PI * (I-1) / N
          W(I) = CMPLX (COS (T), SIN (T))
100     CONTINUE
        RETURN
      ENDIF
C
C   PEFORM FORWARD OR BACKWARD FFTS ACCORDING TO  IS = 1 OR -1
C
      DO 110 I = 1, N
        IP(1,I) = I
110   CONTINUE
      L = 1
      I1 = 1
C
120   I2 = 3 - I1
      DO 130 J = L, N2, L
        CX = W(J-L+1)
        IF (IS .LT. 0)  CX = CONJG (CX)
        DO 130 I = J-L+1, J
          II = IP(I1,I)
          IP(I2,I+J-L) = II
          IM = IP(I1,I+N2)
          IP(I2,I+J) = IM
          DO 130 K = 1, M
            CT = X(K,II) - X(K,IM)
            X(K,II) = X(K,II) + X(K,IM)
            X(K,IM) = CT * CX
130   CONTINUE
      L = 2 * L
      I1 = I2
      IF (L .LE. N2)  GOTO 120
C
      DO 150 I = 1, N
        II = IP(I1,I)
        IF (II .GT. I)  THEN
          DO 140 K = 1, M
            CT = X(K,I)
            X(K,I) = X(K,II)
            X(K,II) = CT
140       CONTINUE
        ENDIF
150   CONTINUE
C
      RETURN
      END
