
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)teltool.c	1.10	(NCSA)	1/11/88";
#endif lint

/*
** Telnet Tool
**
** Copyright (C), 1987 by the Board of Trustees of the University of Illinois
**
*/

#include <sys/types.h>
#include <sys/file.h>

#include <errno.h>

#include <signal.h>
#include <sgtty.h>
#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/scrollbar.h>
#include <suntool/panel.h>
#include <sunwindow/notify.h>
#include <sunwindow/defaults.h>
#include <setjmp.h>
#include "machdep.h"
#include "defs.h"
#include "session.h"

Frame base_frame;
Panel buttonbar;
Panel menubar;
Pixwin *pw;
struct pixfont *zzbold;
struct pixfont *zzgrph;
struct pixfont *ifont;

char start_host[256];
char capname[256];
char teluser[10];
char labelname[350];
char *prog_name = "NCSA Telnet for the Sun (Teltool) ";
char *COPYRIGHT = "Copyright 1987, 1988 Board of Trustees of\
\n\rthe University of Illinois.\n\r";
char *VERSION = "NCSA Telnet for the Sun (Teltool) version 1.2\n\r";
char *STARTUP = "\nUse the Session menu to open connections\n\r";

FILE *capf;
int captureflag = 0;

static short icon_image[] = {
#include "Icons/teltool.icon"
};

mpr_static(teltool_pixrect, 64, 64, 1, icon_image);

Panel_item help;
Panel_item sess;
Panel_item emul;
Panel_item options;
Scrollbar scrx, scry;
Icon fr_icon;
Rect fr_rect;

int DebugLevel = 0;

main(argc, argv)
int argc;
char **argv;
{
	Notify_value		base_destroy();
	Notify_value		initial_conn();
	char				*rindex();
	extern int			bghandler();
	extern Notify_value	helphandler();
	extern int			redraw();
	extern Notify_value	sessionhandler();
	extern Notify_value	emulatehandler();
	extern Notify_value	kbdhandler();
	u_char red[2], green[2], blue[2];

	extern int			RSresize();
	int optionshandler();
	int width, height, top, left, right;
	Rect *r;
	char *p;

	int f = 0;
	int i = 0;

	/*
	** getopt information
	*/

	int getopt();
	extern char *optarg;
	extern int optind;
	int c;

	/*
	** some errors must be printed when the teltool console window is
	** not active.   These go to /dev/console.
	*/

	(void) freopen("/dev/console","w",stderr);

	/*
	** first set up signal code. The coredump scheme doesn't
	** deal with making directories, so we just strip off
	** the leading path if there is one.
	*/

	p = rindex(argv[0],'/');

	if (p == (char *)0)
		p = argv[0];
	else
		p++;

	init_sig(p);

	/*
	** get the font files
	*/

	zzbold = pf_open(
		defaults_get_string("/Teltool/Default_Bold_Font",BOLDFONT,0));
	if (zzbold == NULL) {
		fprintf(stderr,"%s: can't open bold font\n",argv[0]);
		zzbold = pf_default();
	}

	zzgrph = pf_open(
		defaults_get_string("/Teltool/Default_Graphics_Font",GRPHFONT,0));
	if (zzgrph == NULL) {
		fprintf(stderr,"%s: can't open graphics font\n",argv[0]);
		zzgrph = pf_default();
	}

	ifont = pf_open(
		defaults_get_string("/Teltool/Default_Icon_Font",ICONFONT,0));
	if (ifont == NULL) {
		fprintf(stderr,"%s: can't open icon font\n",argv[0]);
		ifont = pf_default();
	}

	/*
	** create the frame icon
	*/

	fr_icon = icon_create(ICON_IMAGE, &teltool_pixrect, 0);
	fr_rect.r_width = 62;
	fr_rect.r_height = 9;
	fr_rect.r_left = 1;
	fr_rect.r_top = 53;
	icon_set(fr_icon, ICON_FONT, ifont, 0);
	icon_set(fr_icon, ICON_LABEL, "N.C.", 0);
	icon_set(fr_icon, ICON_LABEL_RECT, &fr_rect, 0);

	/*
	** create the base frame
	*/

	base_frame = window_create(NULL, FRAME, 
			FRAME_ARGC_PTR_ARGV, &argc, argv,
			FRAME_ICON, fr_icon,
			FRAME_LABEL, "NCSA Telnet Tool - Not Connected",
			WIN_FONT, zzbold,
			WIN_HEIGHT,436 + 14,
			WIN_WIDTH,650 + 14,
			WIN_ERROR_MSG, "teltool: Can't create window.",
			0);

	start_host[0] = '\0';

	/*
	** process argv
	*/

	while ((c = getopt(argc, argv, "h:D:")) != EOF) {

		switch (c) {
			case 'h':
				strcpy(start_host, optarg);
				break;

			case 'D':
				DebugLevel = atoi(optarg);
				break;

			default:
				break;
		}
	}

	if (argv[optind] != (char *)0)
		strcpy(start_host, argv[optind]);

	/*
	** create menu bar
	*/

	menubar = window_create(base_frame, PANEL, PANEL_LABEL_BOLD, TRUE,
							PANEL_BACKGROUND_PROC,bghandler, 
							PANEL_ACCEPT_KEYSTROKE, TRUE,
							0);

	help = panel_create_item(menubar, PANEL_MESSAGE,PANEL_LABEL_STRING,
			"Help", PANEL_ITEM_X, 70,
			PANEL_ACCEPT_KEYSTROKE, TRUE,
			PANEL_EVENT_PROC, helphandler,0);

	top = (int)panel_get(help,PANEL_ITEM_Y);

	sess = panel_create_item(menubar,PANEL_MESSAGE,PANEL_LABEL_STRING,
			"Session", PANEL_ITEM_X,202,
			PANEL_ACCEPT_KEYSTROKE, TRUE,
			PANEL_ITEM_Y,top,
			PANEL_EVENT_PROC,sessionhandler,0);

	emul = panel_create_item(menubar,PANEL_MESSAGE,PANEL_LABEL_STRING,
			"Emulation",PANEL_ITEM_Y,top,
			PANEL_ITEM_X,364,
			PANEL_ACCEPT_KEYSTROKE, TRUE,
			PANEL_EVENT_PROC,emulatehandler,0);


	options = panel_create_item(menubar,PANEL_MESSAGE,PANEL_LABEL_STRING,
			"Options",
			PANEL_ITEM_X,526,
			PANEL_ITEM_Y,top,
			PANEL_ACCEPT_KEYSTROKE, TRUE,
			PANEL_EVENT_PROC, optionshandler,0);

	panel_set(sess,PANEL_ITEM_Y,top,0);
	panel_set(emul,PANEL_ITEM_Y,top,0);
	panel_set(options,PANEL_ITEM_Y,top,0);

	window_fit_height(menubar);

	/*
	** create the canvas user will use for session
	*/

	Session.s_canvas = window_create(base_frame,CANVAS,WIN_CONSUME_KBD_EVENTS,
									 WIN_ASCII_EVENTS,
									 WIN_RIGHT_KEYS,WIN_LEFT_KEYS,
									 WIN_TOP_KEYS,
									 0,
									 WIN_BELOW,menubar,
									 WIN_SHOW,TRUE,
									 CANVAS_FAST_MONO,TRUE,	/* 3/110 */
									 CANVAS_RETAINED,FALSE,
									 CANVAS_WIDTH,640,
									 CANVAS_HEIGHT,384,
									 WIN_EVENT_PROC,kbdhandler,
									 0);

	/*
	** set colormap
	*/

	pw = canvas_pixwin(Session.s_canvas);

	red[0] = green[0] = blue[0] = 255;
	red[1] = green[1] = blue[1] = 0;

	pw_setcmsname(pw, "bwcms");
	pw_putcolormap(pw, 0, 2, red, green, blue);

	window_set(Session.s_canvas, CANVAS_RETAINED,TRUE,
				CANVAS_AUTO_CLEAR, TRUE, CANVAS_FIXED_IMAGE, FALSE,0);

	/*
	** set up scroll bars
	*/

	scrx = scrollbar_create(SCROLL_PLACEMENT, SCROLL_SOUTH, 0);
	scry = scrollbar_create(0);

	scrollbar_set(scrx, SCROLL_NOTIFY_CLIENT, Session.s_canvas, 0);
	scrollbar_set(scry, SCROLL_NOTIFY_CLIENT, Session.s_canvas, 0);

	window_set(Session.s_canvas, WIN_HORIZONTAL_SCROLLBAR, scrx, 0);
	window_set(Session.s_canvas, WIN_VERTICAL_SCROLLBAR, scry, 0);

	scrollbar_set(scrx, SCROLL_OBJECT, Session.s_canvas, 0);
	scrollbar_set(scry, SCROLL_OBJECT, Session.s_canvas, 0);

	scrollbar_set(scrx, SCROLL_OBJECT_LENGTH, 132, 0);
	scrollbar_set(scry, SCROLL_OBJECT_LENGTH, 
		(Session.s_scroll == 0) ? 24 : Session.s_scroll, 0);

	scrollbar_set(scrx, SCROLL_VIEW_START, 0, 0);
	scrollbar_set(scry, SCROLL_VIEW_START, 0, 0);

	scrollbar_set(scrx, SCROLL_VIEW_LENGTH, 80, 0);
	scrollbar_set(scry, SCROLL_VIEW_LENGTH, (Session.s_scroll == 0) ?
		24 : Session.s_scroll, 0);

	scrollbar_set(scrx, SCROLL_ADVANCED_MODE, TRUE, 0);
	scrollbar_set(scry, SCROLL_ADVANCED_MODE, TRUE, 0);

	scrollbar_set(scrx, SCROLL_NORMALIZE, TRUE, 0);
	scrollbar_set(scry, SCROLL_NORMALIZE, TRUE, 0);

	scrollbar_set(scrx, SCROLL_LINE_HEIGHT, 8, 0);
	scrollbar_set(scry, SCROLL_LINE_HEIGHT, 16, 0);

	scrollbar_paint(scrx);
	scrollbar_paint(scry);

	/*
	** erase the canvas, and finish initializing
	*/
	
	pw_writebackground(canvas_pixwin(Session.s_canvas),0,0,640,384, PIX_SRC);

	notify_interpose_destroy_func(base_frame, base_destroy);

	/*
	** initialization code
	*/

	get_defaults();			/* read the user's defaults */
	init_menus();			/* build menus				*/
	VSinit(2);				/* initialize virtual screens */

	Session.s_winval = VSnewscreen((Session.s_scroll == 0) ? 25 :  
			Session.s_scroll, 1, 132, 1);
	RSattach(0,base_frame, Session.s_winval, Session.s_canvas,
			Session.s_fd, scrx, scry);

	window_set(Session.s_canvas, CANVAS_RESIZE_PROC, RSresize, 
				WIN_EVENT_PROC, kbdhandler, 0);

	VGinit();				/* initialize virtual screens */
	VRinit();				/* initialize virtual raster */
	openlog();				/* initialize debugging if needed */
	initcon();				/* initialize connection values */
	normalcursor(menubar);	/* switch to standard cursor	*/
	normalcursor(Session.s_canvas);

    /*
    ** Let's tell everyone who we are and where we came from
    */

    VSwrite( Session.s_winval,   VERSION, strlen(  VERSION));
    VSwrite( Session.s_winval, COPYRIGHT, strlen(COPYRIGHT));
    VSwrite( Session.s_winval,   STARTUP, strlen(  STARTUP));

	/*
	** now put the window up and go.  If there was a command line
	** post event so connection gets made.
	*/

	if (strlen(start_host) > 0) {
		notify_set_event_func(start_host, initial_conn, NOTIFY_SAFE);
		notify_post_event(start_host,KBD_USE, NOTIFY_SAFE);
	}

	window_main_loop(base_frame);
	exit(0);
}

/*
** handler to destroy base frame
*/

Notify_value base_destroy(frame, status)
Frame frame;
Destroy_status status;
{
	Event	*event;
	int		i;

	if (status == DESTROY_CHECKING) {

		int s;

		/*
		** find out if user really wants to leave
		*/

		s = wmgr_confirm(window_get(frame, WIN_FD),
						"Press the left mouse button to confirm Quit.  \
To cancel, press the right mouse button now.");

		/*
		** user doesn't want to leave, so reject the event
		*/

		if (s == 0) {
			(void) notify_veto_destroy(frame);
			return NOTIFY_DONE;
		}

		(void) window_set(frame, FRAME_NO_CONFIRM, TRUE, 0);

	}

	else 
		window_set(frame, FRAME_NO_CONFIRM, FALSE,0);

	/*
	** kill the session to make the window
	** close
	*/

	if (Session.s_valid)
		closecon();

	closelog();
	closetek();

	/*
	** call SunView to do the dirty work
	*/

	return notify_next_destroy_func(frame, status);
}

/*
** initialize menus
*/

init_menus()
{
	init_help_menu();
	init_session_menu();
	init_emulate_menu();
	init_options_menu();
}

/*
** validate menus
*/

validate_menus()
{
	validate_sess_menu();
	validate_emul_menu();
}

/*
** invalidate menus
*/

invalidate_menus()
{
	invalidate_sess_menu();
	invalidate_emul_menu();
}

/*
** set up signal catcher
** we only catch some signals here because the notifier uses
** many.  We assume that it's not interested in these if the
** manual tells the truth.  These are ones that are likely
** to have been unintentional in any case.
*/

static char prog[40];

init_sig(s)
char *s;
{

	int sigcatch();
	
	int (*xsignal())();
	if (defaults_get_boolean("/Teltool/Normal_Dump", False, 0) == True)
		return;

	strcpy(prog, s);

	xsignal(SIGSEGV, sigcatch);
	xsignal(SIGBUS, sigcatch);
	xsignal(SIGILL, sigcatch);
	xsignal(SIGTRAP, sigcatch);
	xsignal(SIGFPE, sigcatch);
	xsignal(SIGEMT, sigcatch);
}

/*
** this is from the SunView manual.  It lets signals coexist
** with that wacky notifier.
*/

int (*xsignal(s, f))()
int s, (*f)();
{
	return (int(*)())notify_set_signal_func(s, f, s, NOTIFY_ASYNC);
}

/*
** catch the signal and abort
*/

sigcatch(sig, code)
int sig, code;
{
	char amsg[256];
	char smsg[60];
	char cname[300];
	extern char *sys_siglist[];

	fprintf(stderr,"%s: %s.  Exiting.\n",prog, sys_siglist[sig]);

	sprintf(amsg,"%s aborted with %s\n",prog,sys_siglist[sig]);
	sprintf(smsg,"%s abort",prog);
	sprintf(cname, "%s/%s",
			defaults_get_string("/Teltool/Dump_Dir", DUMPDIR, 0),
			prog);

	prog_abort(amsg, smsg, teluser, cname, sig);
}

/*
** handle background events so that people don't
** need to be so precise.
*/

bghandler(panel, event)
Panel panel;
Event *event;
{
	extern jmp_buf abortbuf;

	switch ((int)event_id(event)) {

		case MS_RIGHT:
			if (event_x(event) < 162) {
				helphandler(help, event);
				break;
			}

			if (event_x(event) < 304) { 
				sessionhandler(sess, event);
				break;
			}

			if (event_x(event) < 466) {
				emulatehandler(sess, event);
				break;
			}

			optionshandler(sess, event);
			break;

		/*
		** ego trip -- Ah, Stevie, we hardly knew ye
		*/

		case MS_MIDDLE:
			if (event_ctrl_is_down(event) && event_shift_is_down(event)) {
				errmsg("Written by Steve Alexander & Friends (08/07/87)","");
				break;
			}

		default:
			kbdhandler(Session.s_canvas, event);
			break;
	}
}

/*
** handler for initial connection
*/

Notify_value initial_conn(client, event, arg, when)
Notify_client client;
Notify_event event;
Notify_arg arg;
Notify_event_type when;
{
	int stat;
	extern char *prog_name, labelname[], hostname[];
	char hname[10];

	stat = get_connect(start_host);

	if (stat != 0) {
		strcpy(labelname, prog_name);
		strcat(labelname, start_host);
		strcpy(hostname, start_host);
		window_set(base_frame, FRAME_LABEL, labelname, 0);
		strncpy(hname, hostname, 9);
		hname[9] = '\0';

		icon_set(fr_icon, ICON_LABEL, hname, 0);
		window_set(base_frame, FRAME_ICON, fr_icon, 0);
		validate_menus();
	}

	return NOTIFY_DONE;
}

/*
** close tek windows
*/

closetek()
{
	int i;
	for (i = 0 ; i < MAXTEK; i++)
		RGSclose(i);
}
