
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
/*
** @(#)tekstor.h	1.3	(NCSA)	8/11/87
*/

/*
	tekstor.h
	Declarations to allow use of tekstor.c
*/

struct handle {
	char *pool;
	unsigned int poolsize;
	struct handle *next;
};

typedef struct handle HANDLE, *HANDLEP;

typedef struct {
	HANDLE	*firsth, /* beginning of list */
			*thish,	/* used for scanning thru data */
			*lasth;	/* last handle in store */
	int thiselnum,	/* number of currently-viewing element */
		lastelnum;	/* number of last element in store */
		/* element numbers are in [0..(poolsize-1)] */
} STORE, *STOREP;

#ifndef STORMASTER
extern STOREP newstore();
#endif

#ifndef STORMASTER
extern void freestore();
#endif

#ifndef STORMASTER
extern int addstore(), topstore(), nextitem(), unstore();
#endif
