/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


/*
	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	ContourLine		draw a contour line
	
			indata =	pointer to input data
			godata = 	pointer to output data
			value =		the value of the contour level (0-255)
			color =		the color of the contour level (0-255)
			x =			number of x-points in the array
			y =			number of y-points in the array
	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
void	ContourLine(indata,godata,value,color,x,y)
unsigned char			*indata,*godata;
register unsigned char	value,color;
register long			x;
long					y;
{
	register unsigned char	*p,*u;
	unsigned char			*q;
	int						rows_done = 0;

	p = indata;
	q = p + (long)(x * y - 1);
	u = indata + (long)(x - 1);

	while (!rows_done)
	{
		while (p < u)
		{
			if	  (*p < value)
			{
				while (*p < value && p < u) p++;
				if (*p >= value)
					*(godata + (long)(p - indata)) = color;
			}
			else if (*p == value)
			{
				while (*p == value && p < u) p++;
				if (*p < value || *p > value)
					*(godata + (long)(p - indata)) = color;
			}
			else
			{
				while (*p > value && p < u) p++;
				if (*p <= value)
					*(godata + (long)(p - indata)) = color;
			}
		}
		if (u == q)	rows_done = 1;
		else
		{
			u += x;
			p++;
		}
	}

	p = indata;
	q = p + (long)(x * y - 1);
	u = q - (long)(x - 1);

	while (u <= q)
	{
		while (p < u)
		{
			if	  (*p < value)
			{
				while (*p < value && p < u) p += x;
				if (*p >= value)
					*(godata + (long)(p - indata)) = color;
			}
			else if (*p == value)
			{
				while (*p == value && p < u) p += x;
				if (*p < value || *p > value)
					*(godata + (long)(p - indata)) = color;
			}
			else
			{
				while (*p > value && p < u) p += x;
				if (*p <= value)
					*(godata + (long)(p - indata)) = color;
			}
		}
		if (u == q)	return;
		u++;
		p = indata + (long)(x - 1) - (long)(q - u);
	}
}


