clear all;

NPROC=4
NSUBLOCK=12
N=NPROC * NSUBLOCK
EPS=1E-6
MAXITERS=N*2

rand('seed',7);

format long;
format compact;

A=rand(N,N);
A = A' * A;
for i=1:N
  t = min(i,5);
  A(i,i) = A(i,i) + N + i * (10^t);
  b(i) = rand(1);
  x(i) = 0;
  dummy(i) = i;
end

b=b';
x=x';
dummy=dummy';

r=b - A*x;

exact = (inv(A)*b);

condA = cond(A)
lambda=eig(A);
min_lambda=min(lambda);
max_lambda=max(lambda);

maxmin=max_lambda/min_lambda

for i=1:MAXITERS
  rhoone = r' * r;
  if i==1
    p=r;
  else
    beta = rhoone / rhotwo;
    p = r + beta*p;
  end
  q = A*p;
  alpha = rhoone /(p' * q);
  x = x + alpha * p;
  r = r - alpha * q;
  diff = exact - x;
  out(1) = norm(r);
  out(2) = norm(r,'inf');
  out(3) = norm(diff);
  out(4) = norm(diff,'inf');
  out
  if ( out(2) < EPS )
	i
	break
  end;
  rhotwo = rhoone;
end

therest = [ exact x diff r ]
