/*
 * Header file: easy.h
 */

#ifndef _EASY_H_
#define _EASY_H_

#include <stdio.h>

#include "pvm3.h"  /* Includes the most recent pvm3 headerfile */


/* These MUST BE exactly as defined in Fortran-header file fpvm3.h */
#define STRING      0
#define BYTE1       1          /* Default upon process creation */
#define INTEGER2    2
#define INTEGER4    3
#define REAL4       4
#define COMPLEX8    5
#define REAL8       6
#define COMPLEX16   7
#define UNKNOWN    -7          /* The largest, but negative, value */

#define NOCARE        -1       /* Any source or msgtag (Express) */
#define ANYBODY       -1       /* Any source or msgtag; Ruud vd Pas' suggestion */
#define MSG_QUERY     19931000 /* Ask something while HOST in waitall() */
#define   Q_GETLOAD          1 /* Get load info while HOST in waitall() */
#define   Q_GETCLINFO        2 /* Get taskids of another cluster -"- */

#ifndef MAXCLUSTERS
#define MAXCLUSTERS     64     /* Max number of independent NODE-clusters */
#endif

typedef struct t3d_stencil {
  int South;
  int West;
  int North;
  int East;
  int Up;
  int Down;
  int my_x, my_y, my_z;  /* My (x,y,z)-triplet >= 1 */
  int nx, ny, nz;        /* Mesh dimensions */
  int wraparound[3];     /* Future extension: mesh wraparound (torus) flag:
			    Index {0,1,2} ^= {X,Y,Z}-dir */
} T3D_Stencil;


typedef struct mpp_info {
  int mypid;                    /* UNIX process id */
  int myclusterid;              /* Clusted id where node belongs to */
  int datatype;                 /* Active data type for send/recv */
  int stride;                   /* Active stride length */
  int inithow_host;             /* XDRring type: HOST <--> NODEs */
  int inithow_node;             /* XDRring type: NODEs <--> NODEs */
  int nnodes;                   /* Number of nodes */
  int hostid;                   /* PVM taskid of the host */
  int me;                       /* My index in nodeid[] */
  int *nodeid;                  /* PVM taskids of the nodes */
  int *bcast_nodeid;            /* nodes for broadcast: all nodeid[]'s except me */
  int picltrace;                /* PICL-trace ? */
  int host_timestamp;           /* Identifies HOSTID by the time stamp */
  T3D_Stencil mesh;             /* Nearest neighbours in 3D-torus */
} MPP_Info;


/* Include the output from "no_name_clash.csh" here */

#ifndef DO_NOT_PREVENT_NAME_CLASH
/* Generated at Mon Jan 10 17:03:25 EET 1994 */
#define attachproc      easy_attachproc
#define broadcast       easy_broadcast
#define broadcast2d     easy_broadcast2d
#define createproc      easy_createproc
#define dclock          easy_dclock
#define detachproc      easy_detachproc
#define down            easy_down
#define east            easy_east
#define gcol            easy_gcol
#define gcolx           easy_gcolx
#define gcxch           easy_gcxch
#define gdot            easy_gdot
#define getcluster      easy_getcluster
#define getdatatype     easy_getdatatype
#define getload         easy_getload
#define getmeshdim      easy_getmeshdim
#define getstride       easy_getstride
#define getxyz          easy_getxyz
#define gmax            easy_gmax
#define gmin            easy_gmin
#define gmulti          easy_gmulti
#define gprod           easy_gprod
#define gsingle         easy_gsingle
#define gsum            easy_gsum
#define gsync           easy_gsync
#define iprobe          easy_iprobe
#define irecv           easy_irecv
#define isend           easy_isend
#define killcluster     easy_killcluster
#define killproc        easy_killproc
#define loadproc        easy_loadproc
#define mclock          easy_mclock
#define msgdone         easy_msgdone
#define msgwait         easy_msgwait
#define multicast       easy_multicast
#define multicast2d     easy_multicast2d
#define myhost          easy_myhost
#define mynode          easy_mynode
#define north           easy_north
#define numnodes        easy_numnodes
#define probe           easy_probe
#define procinfo        easy_procinfo
#define recv            easy_recv
#define recv2d          easy_recv2d
#define recvinfo        easy_recvinfo
#define send            easy_send
#define send2d          easy_send2d
#define sendrecv        easy_sendrecv
#define setcluster      easy_setcluster
#define setdatatype     easy_setdatatype
#define setstride       easy_setstride
#define south           easy_south
#define storefwd        easy_storefwd
#define storefwd2d      easy_storefwd2d
#define up              easy_up
#define waitall         easy_waitall
#define west            easy_west
#define xfflush         easy_xfflush
#define xfprintf        easy_xfprintf
#define xprintf         easy_xprintf
#endif   /* not DO_NOT_PREVENT_NAME_CLASH */


/* NODE stdout/stderr message routing through HOST */

#ifndef _NO_XPRINTF_
#define  printf xprintf
#define fprintf xfprintf
#define fflush  xfflush
#endif

/*
#ifndef _NO_MAIN_
#define main easy_main
#endif
*/

#ifdef __ProtoGlarp__
#undef __ProtoGlarp__
#endif

#if defined(__STDC__) || defined(__cplusplus)
#define __ProtoGlarp__(x) x
#else
#define __ProtoGlarp__(x) ()
#endif

#if defined(IMA_SUN4) && !defined(__STDC__)
#define const
#endif /* const */

#ifdef __cplusplus
extern "C" {
#endif


#ifndef NO_DECLARATIONS
int numnodes __ProtoGlarp__((void));    /* Number of NODEs in cluster */
int mynode __ProtoGlarp__((void));      /* My NODE index in MPP_Info.nodeid[] */
int myhost __ProtoGlarp__((void));      /* HOST's TASKID */

int south __ProtoGlarp__((void));       /* -Y */
int west __ProtoGlarp__((void));        /* -X */
int north __ProtoGlarp__((void));       /* +Y */
int east __ProtoGlarp__((void));        /* +X */
int up __ProtoGlarp__((void));          /* +Z */
int down __ProtoGlarp__((void));        /* -Z */

int getstride __ProtoGlarp__((void));      /* Current stride used in cluster */
int setstride __ProtoGlarp__((int value)); /* Set new stride */

int getdatatype __ProtoGlarp__((void));    /* Current data type used in cluster */
int setdatatype __ProtoGlarp__((int type));/* Set new data type */

int getmeshdim __ProtoGlarp__((int *nx, int *ny, int *nz)); /* Cluster 3D-dims */
int getxyz __ProtoGlarp__((int *x, int *y, int *z)); /* My (x,y,z) >= 1 */

int getcluster __ProtoGlarp__((void));       /* Active cluster for HOST */
int setcluster __ProtoGlarp__((int id));     /* Set active cluster for HOST */
int killcluster __ProtoGlarp__((int cl_id)); /* Terminate cluster */

int send __ProtoGlarp__((int dest, int msgtag,   
	 void *data, int ndata));            /* Typeless send */

int isend __ProtoGlarp__((int dest, int msgtag,   
	 void *data, int ndata));            /* Intel's NX-call simulator */

int send2d __ProtoGlarp__((int dest, int msgtag, 
	   void *data, int nrows, int ncols, int offset)); 
          /* Typeless matrix block send */

int recv __ProtoGlarp__((int source, int msgtag, 
	 void *data, int ndata));            /* Typeless receive */

int irecv __ProtoGlarp__((int source, int msgtag, void *data, int ndata));
          /* Intel's corresponding NX-call simulator */

int msgdone __ProtoGlarp__((int bufid)); /* Intel's NX-call simulator */

int msgwait __ProtoGlarp__((int bufid)); /* Intel's NX-call simulator */


int sendrecv __ProtoGlarp__((int dest, int send_msgtag,
             void *send_data, int send_ndata,
	     int source, int recv_msgtag,
             void *recv_data, int recv_ndata)); /* send data, recv reply */

int recv2d __ProtoGlarp__((int source, int msgtag,
	   void *data, int nrows, int ncols, int offset));
          /* Typeless matrix block recv */

int recvinfo __ProtoGlarp__((int bufid, int *source, 
	     int *mgstag, int *nbytes));
          /* Receive info */

int storefwd __ProtoGlarp__((int source, int recv_msgtag, 
	     int dest, int send_msgtag,
	     void *data, int ndata));
          /* Typeless store-and-forward */

int storefwd2d __ProtoGlarp__((int source, int recv_msgtag, 
	       int dest, int send_msgtag,
	       void *data, int nrows, int ncols, int offset));
          /* Typeless store-and-forward of matrix block */

int broadcast __ProtoGlarp__((int msgtag, 
	      void *data, int ndata));
          /* Typeless broadcast within the active NODE-cluster only */

int broadcast2d __ProtoGlarp__((int msgtag, 
		void *data, int nrows, int ncols, int offset));
          /* Typeless broadcast of matrix block */

int multicast __ProtoGlarp__((int *set_of_dest, int numdest, 
	      int msgtag, 
	      void *data, int ndata));
          /* Typeless multicast within NODE-cluster + HOST */

int multicast2d __ProtoGlarp__((int *set_of_dest, int numdest, 
		int msgtag, 
		void *data, int nrows, int ncols, int offset));
          /* Typeless multicast of matrix block */

int probe __ProtoGlarp__((int *source, int *msgtag));
          /* A *blocking* test whether specific message has arrived */

int iprobe __ProtoGlarp__((int *source, int *msgtag));
          /* A non-blocking test whether specific message has arrived */

int loadproc __ProtoGlarp__((char *a_out, int how_many));
          /* Starts 'how_many' a_out processes */

int createproc __ProtoGlarp__((char *ndf_file));
          /* Create NODE-processes as needed from data given in NDF-file */

int attachproc __ProtoGlarp__((void));
          /* Attach process to PVM-complex; receive initial infos */

int detachproc __ProtoGlarp__((void));
          /* Leave from PVM-complex, but do not exit */

int killproc __ProtoGlarp__((int id));
          /* Terminate NODE(-index) or HOST */

int waitall __ProtoGlarp__((int cluster_id));
          /* HOST waits for processes to finish for a specific cluster */

MPP_Info *procinfo __ProtoGlarp__((int cluster_id));
          /* MPP_info-table of the specific cluster */

double dclock __ProtoGlarp__((void)); 
          /* Elapsed wall clock time in seconds+msecs since init of timer */

int mclock __ProtoGlarp__((void));    
          /* Elapsed wall clock time in millisecs since init of timer */

int getload __ProtoGlarp__((double *load));
          /* Get the three famous load average values (avenrun[]) */

int gsync __ProtoGlarp__((void));
          /* Global syncronization within active NODE-cluster */

int gsum __ProtoGlarp__((void *data, int ndata, 
			 void *result));
          /* Typeless global summation within active NODE-cluster */

int gprod __ProtoGlarp__((void *data, int ndata, 
			  void *result));
          /* Typeless global product within active NODE-cluster */

int gdot __ProtoGlarp__((void *data1, void *data2, int ndata, 
			  void *result));
          /* Typeless global dot product within active NODE-cluster */

int gmin __ProtoGlarp__((void *data, int ndata, 
			 void *result, int *procindex));
          /* Typeless global minimum within active NODE-cluster */

int gmax __ProtoGlarp__((void *data, int ndata, 
			 void *result, int *procindex));
          /* Typeless global maximum within active NODE-cluster */

int gcol __ProtoGlarp__((void *data, int ndata,
			 void *result, int nresult));
          /* Typeless (general) global concatenation (combine/collect);
	     within active NODE-cluster */

int gcolx __ProtoGlarp__((void *data, int *nlens, void *result));
          /* Typeless global concat for contrib of known length */

int gcxch __ProtoGlarp__((void *data, int blksize, void *result));
          /* Typeless global complete exchange */

void xprintf __ProtoGlarp__(( const char *fmt, ... ));
void xfprintf __ProtoGlarp__(( FILE *fp, const char *fmt, ... ));
void xfflush __ProtoGlarp__(( FILE *fp ));
void gsingle __ProtoGlarp__(( void ));
void gmulti __ProtoGlarp__(( void ));

#endif /* not NO_DECLARATIONS */

#ifdef __cplusplus
}
#endif

#endif /* _EASY_H_ */



