#include "easy.h"

#ifndef COMMON_NAME   /* Map Fortran-common block to C-struct */

#define COMMON_NAME easyinfo_

#if IMA_CNVX || IMA_CNVXN
#undef COMMON_NAME
#define COMMON_NAME _easyinfo_
#endif

#if IMA_CRAY || IMA_CRAY2
#undef COMMON_NAME
#define COMMON_NAME EASYINFO
#endif

#if IMA_RS6K || IMA_HPPA
#undef COMMON_NAME
#define COMMON_NAME easyinfo
#endif

#endif

#ifndef MAXNODES
#define MAXNODES 4096  /* Can be overridden in Fortran-common */
#endif

struct {
  int me;                       /* My index in nodeid[] */
  int hostid;                   /* PVM taskid of the host */
  int mypid;                    /* UNIX process id */
  int nnodes;                   /* Number of nodes */
  /* The following MUST be the last item */
  int nodeid[MAXNODES];         /* PVM taskids of the nodes */
} COMMON_NAME = { 0 };


extern MPP_Info *FUNCALL(procinfo) __ProtoGlarp__((int cl_id));


int
FUNCTION(procinfo) ARGS(`cl_id')
int *cl_id;
{
  MPP_Info *info = FUNCALL(procinfo)(*cl_id);
  if (info) {
    int i;
    COMMON_NAME.me = info->me;
    COMMON_NAME.hostid = info->hostid;
    COMMON_NAME.mypid = info->mypid;
    COMMON_NAME.nnodes = info->nnodes;
    for (i=0; i<info->nnodes; i++) {
      COMMON_NAME.nodeid[i] = info->nodeid[i];
    }
    return info->nnodes;
  }
  else
    return 0;
}


