#include "easy.h"
#include "easydefs.h"

#include <stdio.h>

#define LTGT     <
#define MSG_TYPE MSG_MIN

#define FUNC     gb1min
#define TYPE     char
#define PACK     pvm_pkbyte
#define UNPACK   pvm_upkbyte
#include "gminmax.h"

#define FUNC     gi2min
#define TYPE     short
#define PACK     pvm_pkshort
#define UNPACK   pvm_upkshort
#include "gminmax.h"

#define FUNC     gi4min
#define TYPE     int
#define PACK     pvm_pkint
#define UNPACK   pvm_upkint
#include "gminmax.h"

#define FUNC     gr4min
#define TYPE     float
#define PACK     pvm_pkfloat
#define UNPACK   pvm_upkfloat
#include "gminmax.h"

#define FUNC     gr8min
#define TYPE     double
#define PACK     pvm_pkdouble
#define UNPACK   pvm_upkdouble
#include "gminmax.h"

#define MULTIP   2*
#define FUNC     gz8min
#define TYPE     float
#define PACK     pvm_pkcplx
#define UNPACK   pvm_upkcplx
#include "gminmax.h"

#define MULTIP   2*
#define FUNC     gz16min
#define TYPE     double
#define PACK     pvm_pkdcplx
#define UNPACK   pvm_upkdcplx
#include "gminmax.h"

int gmin(data, ndata, result, procindex)
     void *data; 
     int ndata;
     void *result;
     int *procindex;
{
  int retcode = 0;

  if (ME != HOSTID) { /* Exclude the HOST */

#ifdef PICL
    if (logfp) {
      if (ME==0) tracemsg("gmin()");
      SETIDLETIME();
      TRACEF(20,-4,MSG_MIN,0);
    }
#endif /* PICL */

    switch (DATATYPE) {
    case BYTE1:
      retcode = gb1min(data,ndata,result,procindex);
      break;
    case INTEGER2:
      retcode = gi2min(data,ndata,result,procindex);
      break;
    case INTEGER4:
      retcode = gi4min(data,ndata,result,procindex);
      break;
    case REAL4:
      retcode = gr4min(data,ndata,result,procindex);
      break;
    case REAL8:
      retcode = gr8min(data,ndata,result,procindex);
      break;
    case COMPLEX8:
      retcode = gz8min(data,ndata,result,procindex);
      break;
    case COMPLEX16:
      retcode = gz16min(data,ndata,result,procindex);
      break;
    default:
      fprintf(stderr,
	      "gmin(@%d): Not implemented with data type# %d\n",
	      ME,DATATYPE);
      killproc(ME);
      break;
    }

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(21,-4,MSG_MIN,0);
      UPDATEIDLETIME();
    }
#endif /* PICL */


  }

  return retcode;
}

