#include "easy.h"
#include "easydefs.h"

#include <stdio.h>

#define FUNC     gb1sum
#define TYPE     char
#define PACK     pvm_pkbyte
#define UNPACK   pvm_upkbyte
#include "gsum.h"

#define FUNC     gi2sum
#define TYPE     short
#define PACK     pvm_pkshort
#define UNPACK   pvm_upkshort
#include "gsum.h"

#define FUNC     gi4sum
#define TYPE     int
#define PACK     pvm_pkint
#define UNPACK   pvm_upkint
#include "gsum.h"

#define FUNC     gr4sum
#define TYPE     float
#define PACK     pvm_pkfloat
#define UNPACK   pvm_upkfloat
#include "gsum.h"

#define FUNC     gr8sum
#define TYPE     double
#define PACK     pvm_pkdouble
#define UNPACK   pvm_upkdouble
#include "gsum.h"

#define MULTIP   2*
#define FUNC     gz8sum
#define TYPE     float
#define PACK     pvm_pkcplx
#define UNPACK   pvm_upkcplx
#include "gsum.h"

#define MULTIP   2*
#define FUNC     gz16sum
#define TYPE     double
#define PACK     pvm_pkdcplx
#define UNPACK   pvm_upkdcplx
#include "gsum.h"


int gsum(data, ndata, result)
     void *data; 
     int ndata; 
     void *result;
{
  int retcode = 0;

  if (ME != HOSTID) { /* Exclude the HOST */

#ifdef PICL
    if (logfp) {
      if (ME==0) tracemsg("gsum()");
      SETIDLETIME();
      TRACEF(20,-4,MSG_SUM,0);
    }
#endif /* PICL */

    switch (DATATYPE) {
    case BYTE1:
      retcode = gb1sum(data,ndata,result);
      break;
    case INTEGER2:
      retcode = gi2sum(data,ndata,result);
      break;
    case INTEGER4:
      retcode = gi4sum(data,ndata,result);
      break;
    case REAL4:
      retcode = gr4sum(data,ndata,result);
      break;
    case REAL8:
      retcode = gr8sum(data,ndata,result);
      break;
    case COMPLEX8:
      retcode = gz8sum(data,ndata,result);
      break;
    case COMPLEX16:
      retcode = gz16sum(data,ndata,result);
      break;
    default:
      fprintf(stderr,
	      "gsum(@%d): Not implemented with data type# %d\n",
	      ME,DATATYPE);
      killproc(ME);
      break;
    }

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(21,-4,MSG_SUM,0);
      UPDATEIDLETIME();
    }
#endif /* PICL */

  }

  return retcode;
}

