#include "easy.h"     /* defines MSG_SYNC */
#include "easydefs.h"

#define MSGLEN 0

int gsync()
{
  if (ME != HOSTID && NUMNODES > 1) { /* Exclude the HOST */
    int zero_message = NOCARE;

#ifdef PICL
    if (logfp) {
      if (ME==0) tracemsg("gsync()");
      SETIDLETIME();
      TRACEF(10);
      TRACEF(20,-1,0,0);
    }
#endif /* PICL */

    if (ME > 0) { /* Nodes with # > 0 */
      pvm_initsend(INITHOW_node);
      pvm_pkint(&zero_message, MSGLEN, 1);
      pvm_send(NODEID[0], MSG_SYNC);

      pvm_recv(ANYBODY, MSG_SYNC);
      pvm_upkint(&zero_message, MSGLEN, 1);
    }
    else { /* Node == 0 */
      int j;

      for (j=1; j<NUMNODES; j++) {
	pvm_recv(ANYBODY, MSG_SYNC);
	pvm_upkint(&zero_message, MSGLEN, 1);
      }
      
      pvm_initsend(INITHOW_node);
      pvm_pkint(&zero_message, MSGLEN, 1);
      pvm_mcast(&NODEID[1], NUMNODES-1, MSG_SYNC);
    }

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(21,-1,0,0);
      UPDATEIDLETIME();
    }
#endif /* PICL */
    
  }

  return 0;
}
