#define _NO_XPRINTF_

#include "easy.h"

#include <stdio.h>
#ifdef SYSVSTR
#include <string.h>
#else
#include <strings.h>
#endif
#include <unistd.h>
#include <stdlib.h>

static char *createndf(fp, file, how_many, meshdim)
     FILE **fp;
     char *file;
     int how_many;
     char *meshdim;
{
  char *ndffile = file;
  
  if (!file) {
    int lenp=0;
    char *p = getenv("TMPDIR");
    if (p) lenp = strlen(p);
    ndffile = (char *)malloc((20 + lenp) * sizeof(*ndffile));
    sprintf(ndffile,"%s/__pid%d.load__",
	    p?p:".",
	    getpid());
  }

  *fp = fopen(ndffile,"w");
  if (how_many != NOCARE) 
    fprintf(*fp,"%d 1 1\n",how_many);
  else 
    fprintf(*fp,"%s\n",meshdim ? meshdim : "1 1 1");

  return ndffile;
}


static int appendndf(fp, startproc, endproc, machine, a_out, all_args)
     FILE *fp;
     int startproc;
     int endproc;
     char *machine;
     char *a_out;
     char *all_args;
{
  fprintf(fp,"%d-",startproc);
  fprintf(fp,(endproc != NOCARE) ? "%d " : "*",
	  endproc);
  fprintf(fp," %s %s %s\n",
	  machine,a_out,
	  all_args ? all_args : "");
  return (endproc - startproc + 1);
}


int loadproc(a_out, how_many)
     char *a_out;
     int how_many;
{
  char hostname[64];
  char *ndffile = NULL;
  char *exename = NULL;
  char *meshdim = NULL;
  char *params = NULL;
  FILE *fp;
  char *p;
  int i;

  if ( (how_many <= 0 && how_many != NOCARE) || (!a_out) ) return 0;

  if (how_many == NOCARE) { /* via environment parameter EASY_NCPUS */
    meshdim = getenv("EASY_NCPUS");
    /* if (meshdim) printf("loadproc: EASY_NCPUS = '%s'\n",meshdim); */
  }

  if (how_many == NOCARE && !meshdim) return 0;

  exename = (char *)malloc((strlen(a_out) + 1)*sizeof(*exename));
  strcpy(exename,a_out);

  hostname[0] = '\0';

  p = strchr(exename,':');
  if (p) { /* exename is in format "hostname:a.out" */
    char *ptmp = p + 1; /* Next to ':' */
    strncpy(hostname,exename,sizeof(hostname));
    p = strchr(hostname,':');
    *p = '\0';  /* Now hostname equals to "hostname\0" ! */
    strcpy(exename,ptmp); /* New exename */
  }
  else {
    p = strchr(exename,'@');
    if (p) { /* exename is in format "a.out@hostname" */
      *p++ = '\0'; /* exename is now "a.out" because '@' is '\0'
		      and skip over '@' (or which is currently '\0') */
      params = strchr(p,' '); /* Next blank */
      if (params) *params++ = '\0';
      strncpy(hostname,p,sizeof(hostname));
    }
  }

  if (strlen(hostname) == 0) strcpy(hostname,"*"); /* Wildcard */

  ndffile = createndf(&fp,NULL,how_many,meshdim);
  appendndf(fp,0,
	    (how_many != NOCARE) ? how_many-1 : NOCARE,
	    hostname,exename,params);
  fclose(fp);

  /*
  {
    char cmd[80];
    sprintf(cmd,"cat %s",ndffile);
    printf("loadproc> %s\n",cmd);
    system(cmd);
  }
  */

  how_many = createproc(ndffile);

  remove(ndffile);

  free(exename);

  return how_many;
}


