/*
 *
 * Header file 'picl.h': EASYPVM-to-PICL -interface to generate trace files 
 *                       for use by ParaGraph
 *
 */

#ifndef _PICL_H_
#define _PICL_H_

#include <stdio.h>

#define PICLHOST -32768
#define logfp easy_logfp

#ifdef __ProtoGlarp__
#undef __ProtoGlarp__
#endif

#if defined(__STDC__) || defined(__cplusplus)
#define __ProtoGlarp__(x) x
#else
#define __ProtoGlarp__(x) ()
#endif

#ifdef __cplusplus
extern "C" {
#endif

void traceenable __ProtoGlarp__((char *name, int verbose));
void tracemsg __ProtoGlarp__((char *s));
void traceexit __ProtoGlarp__((void));
void UPDATEIDLETIME __ProtoGlarp__((void));
void SETIDLETIME __ProtoGlarp__((void));
void TRACETIME __ProtoGlarp__((void));
void TRACEF __ProtoGlarp__((int i, ...));

#ifdef __cplusplus
}
#endif

#ifdef _PICL_C_

int picl_me = -1993;             /* Same as mynode(), except HOST == -32768 */
FILE *logfp = NULL;              /* Currently active logfile pointer */

#else

extern FILE *logfp;
extern int picl_me;

#endif /* _PICL_C */


#endif /* _PICL_H_ */
