/*
 * common-structdesc.h,v 1.1 1994/01/28 17:05:56 franktor Exp
 *
 * structdesc.h
 *
 * Description of datastructures usable for code
 *
*/

#ifndef COMMON_STRUCTDESC_H
#define COMMON_STRUCTDESC_H

#include <sr-general.h>
#ifndef VMS
#include <high/structcodec.h>
#include <high/common-structs.h>
#else
#include <structcodec.h>
#include <common-structs.h>
#endif

				/* structures from general.h */
extern elemDesc desc_octetString[];

extern elemDesc desc_DatabaseName[];
extern elemDesc desc_HlvlRecords[];
extern elemDesc desc_HlvlNamePlusRecord[];
extern elemDesc desc_HlvlDiagRec[];

				/* structures from sr-api.h */
extern elemDesc desc_RCNameAndId[];
extern elemDesc desc_RecordComposition_u_u[];
extern elemDesc desc_RecordComposition[];
extern elemDesc desc_Query[];
extern elemDesc desc_RPNQuery[];
extern elemDesc desc_AttributeElement[];
extern elemDesc desc_AttributeList[];
extern elemDesc desc_AttributesPlusTerm[];
extern elemDesc desc_operandType[];
extern elemDesc desc_Operand[];
extern elemDesc desc_RPNStructureType[];
extern elemDesc desc_Operator[];
extern elemDesc desc_RPNStructure[];
extern elemDesc desc_DiagRec[];
extern elemDesc desc_NamePlusRecord[];
extern elemDesc desc_Records[];
extern elemDesc desc_EXTERN[]; 


/* structures from general.h */

elemDesc desc_octetString[] = {
  { elemInt,	   	0,		  	sizeof(int) },  
  { elemCharPtr,   	0,		  	sizeof(char *) },  
  { elemDone, 		0, 			0 } 
};




/* structures from eapi.h */

elemDesc desc_DatabaseName [] = {
  { elemCharPtr, 	0, 			sizeof(char*) },
  { elemStructPtr, 	desc_DatabaseName, 	sizeof(struct DatabaseName*) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HlvlRecords_u_u[] = {
  { elemStructPtr,	desc_HlvlNamePlusRecord, sizeof(HlvlNamePlusRecord *) }, 
  { elemStructPtr,	desc_HlvlDiagRec,	sizeof(HlvlDiagRec *) }, 
  { elemDone,		0,			0}
};

elemDesc desc_HlvlRecords[] = {
  { elemEnum,		0,			sizeof(HlvlRecordKind) },
  { elemUnion,		desc_HlvlRecords_u_u,	0,			0 },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HlvlRecord[] = {
  { elemStruct,		desc_octetString,	sizeof(octetString) },
  { elemCharPtr,	0,			sizeof(char *) },
  { elemCharPtr,	0,			sizeof(char *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HlvlNamePlusRecord_u_u[] = {
  { elemStruct,		desc_HlvlRecord,	sizeof(struct HlvlRecord) },
  { elemStructPtr,	desc_HlvlDiagRec,	sizeof(HlvlDiagRec *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HlvlNamePlusRecord[] = {
  { elemEnum,		0,		sizeof(HlvlNamePlusRecordKind) },
  { elemUnion,		desc_HlvlNamePlusRecord_u_u, sizeof(struct HlvlNamePlusRecord_u_u *), 0},
  { elemStructPtr,	desc_HlvlNamePlusRecord, sizeof(HlvlNamePlusRecord *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HlvlDiagRec[] = {
  { elemCharPtr,	0,			sizeof(char *) },
  { elemInt,		0,			sizeof(int) },
  { elemCharPtr,	0,			sizeof(char *) },
  { elemDone, 		0, 			0 } 
};



/* Structures from sr-api.h */

elemDesc desc_RCNameAndId[] = {
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemStructPtr,	desc_RCNameAndId,	sizeof(struct RCNameAndId *), 0},
  { elemDone,		0,			0,			0 }
};

elemDesc desc_RecordComposition_u_u[] = {
  { elemStructPtr,	desc_RCNameAndId,	sizeof(struct RCNameAndId *), 0},
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemDone,		0, 			0,			0 }
};

elemDesc desc_RecordComposition[] = {
  { elemBoolean,	0,			sizeof(Boolean),	0 },
  { elemUnion,		desc_RecordComposition_u_u,	0,		0 },
  { elemDone,		0,			0,			0 }
};

elemDesc desc_Query_u_q[] = {
  { elemStructPtr,      desc_RPNQuery,          sizeof(RPNQuery *) },
  { elemStructPtr,      desc_octetString,       sizeof(octetString *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_Query[] = {
  { elemEnum,   	0,		  	sizeof(queryType) },  
  { elemUnion,   	desc_Query_u_q,	  	0,			0 },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_RPNQuery[] = {
  { elemCharPtr,   	0,		  	sizeof(char *) },  
  { elemStructPtr,   	desc_RPNStructure, 	sizeof(RPNStructure *) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_AttributeElement[] = {
  { elemInt,	   	0,		  	sizeof(int) },  
  { elemInt,	   	0,		  	sizeof(int) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_AttributeList[] = {
  { elemStructPtr,   	desc_AttributeElement, 	sizeof(AttributeElement *) },  
  { elemStructPtr,   	desc_AttributeList,	sizeof(AttributeList *) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_AttributesPlusTerm[] = {
  { elemStructPtr,   	desc_AttributeList,  	sizeof(AttributeList *) },  
  { elemStructPtr,   	desc_octetString,	sizeof(octetString *) },  
  { elemStructPtr,   	desc_AttributesPlusTerm,sizeof(AttributesPlusTerm *) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_Operand[] = {
  { elemEnum,   	0,		  	sizeof(operandType) },  
  { elemStructPtr,   	desc_AttributesPlusTerm,sizeof(AttributesPlusTerm) },  
  { elemCharPtr,   	0,		  	sizeof(char *) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_RPNStructure_u_u[] = {
  { elemStructPtr,   	desc_Operand,	  	sizeof(Operand *) },  
  { elemStructPtr,   	desc_RPNStructure,  	sizeof(RPNStructure *) },  
  { elemStructPtr,   	desc_RPNStructure,  	sizeof(RPNStructure *) },  
  { elemEnum,   	0,		  	sizeof(Operator) },  
  { elemDone, 		0, 			0 } 
};


elemDesc desc_RPNStructure[] = {
  { elemEnum,   	0,		  	sizeof(RPNStructureType) },  
  { elemUnion,   	desc_RPNStructure_u_u,	0,				0 },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_DiagRec[] = {
  { elemCharPtr,   	0,		  	sizeof(char *) },  
  { elemInt,	   	0,		  	sizeof(int) },  
  { elemCharPtr,   	0,		  	sizeof(char *) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_NamePlusRecord_u_u[] = {
  { elemStructPtr,   	desc_EXTERN,	  	sizeof(EXTERN *) },  
  { elemStructPtr,   	desc_DiagRec,	  	sizeof(DiagRec *) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_NamePlusRecord[] = {
  { elemCharPtr,   	0,		  	sizeof(char *) },  
  { elemEnum,   	0,		  	sizeof(nprRecord) },  
  { elemUnion,   	desc_NamePlusRecord_u_u, 0,			1 },  
  { elemStructPtr,   	desc_NamePlusRecord,	sizeof(NamePlusRecord *) },  
  { elemDone, 		0, 			0 } 
};

#if 0
elemDesc desc_Records_u_u[] = {
  { elemStructPtr,   	desc_NamePlusRecord,	sizeof(NamePlusRecord *) },  
  { elemStructPtr,   	desc_DiagRec,		sizeof(DiagRec *) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_Records[] = {
  { elemEnum,   	0,		  	sizeof(recNamePlusRecord) },  
  { elemUnion,   	desc_Records_u_u,  	0,			0 },  
  { elemDone, 		0, 			0 } 
};
#endif

elemDesc desc_EXTERN[] = {
  { elemCharPtr,   	0,		  	sizeof(char *) },  
  { elemInt,	   	0,		  	sizeof(int) },  
  { elemStructPtr,   	desc_octetString,  	sizeof(octetString *) },  
  { elemEnum,   	0,		  	sizeof(externEncodeType) },  
  { elemStructPtr,   	desc_octetString,  	sizeof(octetString *) },  
  { elemDone, 		0, 			0 } 
};

#endif /* COMMON_STRUCTDESC_H */
