/*
 * sr-logger.h,v 1.1 1994/01/28 17:05:46 franktor Exp
 *
 * logger.h
 *
 * Copyright (c) 1992 Nordic SR-NET
 * Geir Pederesen, Geir.Pedersen@usit.uio.no
 *
*/


#ifndef SR_LOGGER_H
#define SR_LOGGER_H

/* If you change this, also update the logLeves[] array in logger.c */
typedef enum Facility { facApp, facHigh, facLow, facPM, facMarc, facUtil, facLog, facStruct, facTLV, facAddr, NOFACILITIES } Facility; 
#define facAll (-1)

#include <sr-general.h>		/* This must be after definition of Facility */
#include <stdio.h>

#define DEFAULT_LOG_PREFIX "/usr/spool/log/"
#define DEFAULT_LOG_FILE   "sr.log"

typedef enum LogLevel { llevAll, llevTrace, llevDebug, llevExceptions, llevNotice, llevNone } LogLevel; 

void facLogLevel ARGDCL (( Facility fac, LogLevel logLevel ));
void initLogger  ARGDCL (( const char *where ));

#if defined(VMS) && !defined(LOG)
#define LOG SR_LOG
#endif

void LOG VA_ARGDCL(( Facility fac, LogLevel logLevel, const char *format VA_DOTS ));

#define CHECKHEAP if(!malloc_verify()) { \
   LOG ( facUtil, llevDebug, "malloc_verify() failed" ); \
   exit ( 1 ); \
   }

char *SR_strdup ARGDCL ((const char *str));

#endif /* SR_LOGGER_H */
