#include <string.h>
#ifndef VMS
#include <malloc.h>
#else
#include <stdlib.h>
#endif

/* From lib/sr/util.c */

char *safe_strdup ( const char *s )
{
   return (s ? strcpy ((char *) malloc ((strlen (s)) + 1), s) : (char *)0);
}

int safe_strlen ( const char *s )
{
   return (s ? strlen ( s ) : 0);
}

char *safe_strcpy ( char *s1, const char *s2 )
{
   return ((s1 && s2) ? strcpy (s1, s2) : s1);
}
