/*
 * testconv.c,v 1.1 1994/01/28 17:06:27 franktor Exp
 *
 * This is just an experimental main() to test out the functions.
 */

#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sr-general.h>
#include <sr-converter.h>
#include "marc/marc.h"
#include "config.h"
#ifndef __CEXTRACT__
#include <marcproto.h>
#include "proto.h"
#endif
#ifdef __sun__
#include <sunos.h>
#endif

void main() {
  init_converter();
  do_some_debug();
}

/*
 * Some debugging:
 */

void do_some_debug() {
  octetString *in, *out;
  Marcrecord *rec;
  CV_Status s;

  in = read_debug_file();

  s = Convert("MARC", "NORMARC-text", "NORMARC-data",
              (void *) in, (void **) &out);
  printf("Convert returned %d\n", s);

  if (s == CV_OK)
    printf("Length: %d\nData:\n%s\n", out->len, out->value);
}

octetString *read_debug_file() {
  octetString *os = (octetString *) malloc(sizeof(octetString));
  int fd;
  int length;

  fd = open("data.text", O_RDONLY);
  if (fd == -1) {
    perror("open");
    exit(1);
  }
  length = (int) lseek(fd, 0, SEEK_END);
  (void) lseek(fd, 0, SEEK_SET);
  os->len = length + 1;
  os->value = (char *) malloc(os->len);
  if (read(fd, os->value, length) == -1) {
    perror("read");
    exit(1);
  }
  close(fd);
  *(os->value + length) = '\0';
  return os;
}
