#       enukey - extract unique key
#
#	$RCSfile: enukey.pl,v $
#	$Revision: 0.13 $
#	$Author: marten $
#	$Date: 1994/09/20 12:15:24 $
#

require "entype.pl";

sub enukey {

    local(*e) = @_;
    local($ukey) = "";

    local($type) = &entype(*e);

    foreach (split(/\s+/,$UNIQ{$type})) {
	local($val) = &getukey($e{$_});
	if ($val) {
	    if ($ukey) {
		$ukey .= "\t".$val;
	    }
	    else {
		$ukey = "%".$OBJSORT{$type}.$val;
	    }
	}
    }
    return $ukey;
}

sub getukey {
    local ($result) = @_;

    $result =~ tr/A-Z/a-z/;
    $result =~ s/\s+/ /g;
    $result =~ s/\s+$//;
    return $result;
}

1;
