#	$RCSfile: template.pl,v $
#	$Revision: 2.0 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/08 10:47:30 $

# template.pl - spits out a template for an object, based on the config
# file. Assumes that the config has already been read.
# Takes object type as input. Outputs to currently selected output.

sub Template {
    local($output, $type) = @_;

    local(%mand) = ();
    local(%mult) = ();
    local(%obsoleted) = ();

    foreach (split(/\s+/, $OBJMAND{$type})) {
	$mand{$_} = 1;
    }

    foreach (split(/\s+/, $OBJMULT{$type})) {
	$mult{$_} = 1;
    }

    foreach (split(/\s+/, $OBS{$type})) {
	$obsoleted{$_} = 1;
    }

    local(@obsoleted)=();
    
    print $output "\n";
    
    foreach (split(/\s+/, $OBJATSQ{$type})) {
	if ($obsoleted{$_}) {
	    push(@obsoleted, sprintf("%-12s %-12s\n", $ATTL{$_}.":", "[obsoleted]"));
	} else {
	    printf $output "%-12s %-12s %-12s\n",
	    $ATTL{$_}.":",
	    $mand{$_} ? "[mandatory]" : "[optional]",
	    $mult{$_} ? "[multiple]"  : "[single]";
	}
    }
    
    foreach (@obsoleted) {
       print $output $_;
    }
        
}

1;
