/***************************************
  $Revision: 1.9 $

  Error reporting (er) er_facilities.h - list of facilities (modules)

  Status: NOT REVUED, TESTED, 
 
  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* 
NOTE:  modify the m4 file only, do not change the resulting .h !!!
*/

/* this #include is just for cxref to not get lost completely :-) */
#include <erroutines.h>

/* this is the file for adding new facilities.
   This requires three steps:
   1. Prepare and include a file with your error messages (see other files).	
      Please follow the filename convention er_??_errors.c 
   2. Declare your facility number in the enum (before the FAC_LAST)

   only when that's ready (for not to prevent other people from working)

   3. Add your facility to the facility table, using the GLUP macro
	(it takes a two-letter code and a description of the facility).
	This will add a pointer to the module-specific error table
	to the global table.
*/

/* m4 macro */
define( `GLUP', `divert(9)#include "er_$1_errors.h"
divert(8)DEFFAC($1,$2),
divert FAC_$1  ' )

changecom(/*,*/)
undefine(`define')
undefine(`ifdef')
undefine(`include')


typedef enum {
	FAC_NONE=0,
	GLUP(RX, "radix tree indexing for IP/route objects"), 
	GLUP(ER, "error system") ,                           
	GLUP(IP, "IP conversion library"),                   
	GLUP(UP, "upper update layer") ,                     
	GLUP(UT, "general utilities and wrappers") ,         
	GLUP(WH, "embedded whois client") ,                  
	GLUP(RP, "radix tree payload functions"),            
	GLUP(QI, "query execution"),                         
	GLUP(QC, "query preparation"),                       
	GLUP(PW, "protocol whois"),                          
	GLUP(SK, "socket communication"),                    
	GLUP(TH, "thread handling"),                         
	GLUP(SQ, "SQL interface"),                           
	GLUP(PM, "protocol mirror"), 
	GLUP(MM, "MIME parser"), 
	GLUP(SV, "main server functions"), 
	GLUP(AC, "access control"),
	GLUP(UD, "core update process"),
	GLUP(PA, "GPG authentication"), 
	GLUP(PC, "Protocol config"),
	FAC_LAST
} er_fac_code_t;
 
/* paste the "include"s here. This will define error codes. */
undivert(9)

#ifndef ER_IMPL
/* just a declaration for modules using this */
#include "erroutines.h"
extern er_fac_t er_fac_err[];
#else 
  er_fac_t 	er_fac_err[] = {
/*    {FAC_NONE}, */
undivert(8)
    {FAC_LAST}
  };
#endif /* ER_IMPL */

