#ifndef TA_H
#define TA_H

#include <glib.h>
#include <pthread.h>
#include <stdio.h>

#include "stubs.h"
#include "memwrap.h"
#include "sk.h"
#include "timediff.h"

/* thread activity monitor */
#define TA_TYPE_LEN 16
#define TA_ACT_LEN 256
#define TA_PRINT_LEN (TA_ACT_LEN+64)

typedef struct 
{  
  pthread_t  thread_id;                /* thread id */  
  ut_timer_t sessionstart;             /* time the session started */
  ut_timer_t taskstart;                /* time the last task started */
  int        sock;                     /* socket */
  sk_conn_st *condat;                  /* sk's connection data struct */
  char       type[TA_TYPE_LEN];
  char       activity[TA_ACT_LEN];     /* current activity (eg query) */
  int        tasks;                   /* number of activities(used to calculate the average) */
} ta_str_t;


#ifdef TA_IMPL
/* GLOBALs (private to the module)*/
GList *ta_list = NULL;
pthread_mutex_t ta_mutex = PTHREAD_MUTEX_INITIALIZER;
#endif

#ifdef __cplusplus
extern "C" {
#endif


/* prototypes */
void TA_add(int  sock, char *type);
void TA_delete(void); 
void TA_setactivity(char *activity);
void TA_setcondat(sk_conn_st *condat);
char * TA_tostring(void);
void TA_increment(void);
void TA_trigger(char *type, int sock, pthread_t thread_id);
void TA_reset_counters(pthread_t thread_id);

#ifdef __cplusplus
}
#endif


#endif

