#! /bin/sh

# Copyright (c) 2000,2001,2002               RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# build.sh
# This script is a wrapper to configure with some site-specific variables
# (mainly locations of external packages) set.
# It does not "build" everything per se, but you can always just
# put a "gmake" as the last line.:)

##
## Required configuration variables
##

# Note: Suggested system-specific variables are defined below

# Root directory of the binary installation
TOPDIR=/usr/local/whoisd

# Variant of RPSL to implement
# Currently one of RIPE, APNIC, or IETF
RPSL_VARIANT=RIPE

# Where is the glib-config script
GLIBCONF=/usr/local/bin/glib-config

# MySQL include and lib directories
MYSQLINC=/usr/local/mysql/include/mysql
MYSQLLIB=/usr/local/mysql/lib/mysql
MYSQLBIN=/usr/local/mysql/bin

# c-client build directory
CCLIENTINC=/usr/local/include
CCLIENTLIB=/usr/local/lib

# command to run the GNU Privacy Guard
GPGCMD=/usr/local/bin/gpg


##
## System-specific configurations are defined here
##

# Solaris 8, with additional software installed in /usr/local
#GLIBCONF=/usr/local/bin/glib-config
#MYSQLINC=/usr/local/mysql/include/mysql
#MYSQLLIB=/usr/local/mysql/lib/mysql
#MYSQLBIN=/usr/local/mysql/bin
#CCLIENTINC=/usr/local/include
#CCLIENTLIB=/usr/local/lib
#GPGCMD=/usr/local/bin/gpg

# Red Hat Linux 7.2
#GLIBCONF=/usr/bin/glib-config
#MYSQLINC=/usr/include/mysql
#MYSQLLIB=/usr/lib
#MYSQLBIN=/usr/bin
#CCLIENTINC=/usr/include/imap
#CCLIENTLIB=/usr/lib
#GPGCMD=/usr/bin/gpg
#LIBS="-L/usr/kerberos/lib -lgssapi_krb5"
#export LIBS

# FreeBSD 4.3, with additional software installed in /usr/local
#GLIBCONF=/usr/local/bin/glib-config
#MYSQLINC=/usr/local/mysql/include/mysql
#MYSQLLIB=/usr/local/mysql/lib/mysql
#MYSQLBIN=/usr/local/mysql/bin
#CCLIENTINC=/usr/local/include
#CCLIENTLIB=/usr/local/lib
#GPGCMD=/usr/local/bin/gpg
#CFLAGS="-I/usr/local/include/bind -L/usr/local/lib"  
#export CFLAGS

# SCO Unix, with additional software installed in /usr/local
# WARNING: this installation has *not* been tested by the NCC.
#GLIBCONF=/usr/local/bin/glib-config
#MYSQLINC=/usr/local/mysql/include/mysql
#MYSQLLIB=/usr/local/mysql/lib/mysql
#MYSQLBIN=/usr/local/mysql/bin
#CCLIENTINC=/usr/local/include
#CCLIENTLIB=/usr/local/lib
#GPGCMD=/usr/local/bin/gpg
#CFLAGS="-DSCO -I/usr/local/include/bind -L/usr/local/lib"  
#export CFLAGS


# To use Solaris Workshop C, uncomment these lines
#CC="ucbcc -xCC"
#export CC

#Supplementary arguments to configure: taken from command line
CONFIGARGS="$@"

# Invoke the configure script
./configure \
--with-mysqlinc=$MYSQLINC \
--with-mysqllib=$MYSQLLIB \
--with-mysqlbin=$MYSQLBIN \
--with-cclientinc=$CCLIENTINC \
--with-cclientlib=$CCLIENTLIB \
--with-glibconfig=$GLIBCONF \
--with-gpgcmd=$GPGCMD \
--prefix=$TOPDIR \
$CONFIGARGS


CONF_RET=$?
if [ $CONF_RET -ne 0 ]
then
 echo "Configure failed. Exiting\n" 
 exit $CONF_RET
fi


# create appropriate links in the defs directory
cd defs
cp variants/$RPSL_VARIANT/*.xml .
cp variants/$RPSL_VARIANT/*.h .
cp variants/$RPSL_VARIANT/Makefile.syntax .
cd ..
cd include
cp ../defs/variants/$RPSL_VARIANT/*.def .
cd ..

