#! /usr/bin/perl -w

# Copyright (c) 2001,2002                 RIPE NCC
# 
# 
# All Rights Reserved
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
# 
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: help2nroff.pl,v 1.2 2002/02/19 17:22:59 shane Exp $

# file: help2nroff.pl
# description: convert HELP.txt into a format understood by nroff (man pages)

use strict;
use English;

local $INPUT_RECORD_SEPARATOR = "";

# read each chunk of text separated by blank lines
while (defined(my $input = <>)) {
    chomp($input);
    if ($input =~ /\n-+$/) {
        # section headers end with a line of ---
        $input =~ s/\n-+$//;
        print ".SH ", uc($input), "\n";
    } else {
        # otherwise print the argument
        print ".IP \"$input\"\n";
        # and then the description
        my $desc = <> || die;
        chomp($desc);
        print $desc, "\n";
    }
}

