/**********************************************************************
 *
 * Itty-Bitty Black Book/2 installation program.
 *
 * Version 1.24
 * September 24, 1994
 *
 * Copyright (C) 1994 by 
 * James E Johnson Jr.
 * All Rights Reserved.
 *
 **********************************************************************/


"@ECHO OFF"

call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs
call RxFuncAdd "SysCls", "RexxUtil", "SysCls"

arg FullPathName

if FullPathName = "" then
  do
    call SysCls
    say ""
    say "Usage:"
    say " "
    say "  INSTALL FullPathName"
    say ""
    say "  FullPathname is a combination of both the drive letter and directory path,"
    say "  if the directory does not exist it will be created."
    say ""
    say ""
    say "  Example:"
    say ""
    say "  INSTALL c:\apps\ibbook              -- will install IBB/2 in c:\apps\ibbook"
  end
else
  do
    call SysCls
    say "Installing Itty-Bitty Black Book/2 in "FullPathName"."
    rc = SysFileTree( FullPathName, "dirs", "D")
    if (dirs.0 = 0) then
      do
        rc = SysMkDir(FullPathName)
        if (rc \= 0) then
          do
            say "Couldn't create directory "FullPathName"."
          exit
        end
      end
    copy ibbook.exe     FullPathName ">NUL"
    copy ibbook.hlp     FullPathName ">NUL"
    copy ibbook.doc     FullPathName ">NUL"
    copy readme.NOW     FullPathName ">NUL"
    copy install.cmd FullPathName ">NUL"
    rc = SysFileTree( "ibbook.key", "files", "F")
    if (files.0 \= 0) then
      do
        copy ibbook.key FullPathName ">NUL"
      end
    CR = D2C(13)
    rc = SysCreateObject("WPProgram", "Itty-Bitty"CR" Black Book/2", "<WP_DESKTOP>", "PROGTYPE=PM;EXENAME="FullPathname"\ibbook.exe", "REPLACE")
    say "Installation complete."
    say " "
    say "Remember to take a look at readme.NOW"
  end

