/************************************************************
 *** OS2: This file contains additional routines          ***
 ***      only needed in the OS/2-version.                ***
 ***                                                      ***
 ***   last modified: 12/01/92                            ***
 ***   Authors:  Thilo Schuster (term@godot.stgt.sub.org) ***
 ***         Herbert Neugebauer (haen@veces.stgt.sub.org) ***
 ***                                                      ***
 ***  please send bug reports to term@godot or haen@veces ***
 ***                                                      ***
 ***  Remark: the things in os2patch.c are used in every  ***
 ***          executable, os2trn.c only in trn            ***
 ************************************************************/

#define OS2_PATCHES_C

#define EABUF 0L

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include "os2patch.h"


/*****************************************************************
 *****                    global variables                    ****
 *****************************************************************/

INFO uupc_rc_settings;

/*****************************************************************
 *****                        functions                       ****
 *****************************************************************/


/***********************************************
 *** the fopen function of EMX/GCC has some  ***
 *** restrictions, (e.g. you cannot open     ***
 ***  one file two times simultaneously).    ***
 *** So we replace the fopen-calls in the    ***
 *** the source by the fos2open-call so we   ***
 *** can do the enhancements here.           ***
 ***********************************************/

/*FILE *fos2open(const char *filename, const char *mode) */
FILE *fblaopen(const char *filename, const char *mode)
{   char newmode[3+1];
    HFILE   FileHandle;
    ULONG   Action;
    unsigned long  rc;              /* Return code */
    ULONG   openflags, shareflags;
 
    Action = 2;
 
    if (*mode == 'r') {
        if (*(mode+1) == '+') {
            openflags = OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS;
            shareflags = OPEN_ACCESS_READWRITE;
        }
        else {
            openflags = OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS;
            shareflags = OPEN_ACCESS_READONLY;
        }
    }
    else
    if (*mode == 'w') {
        if (*(mode+1) == '+') {
            openflags = OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS;
            shareflags = OPEN_ACCESS_READWRITE;
        }
        else {
            openflags = OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_REPLACE_IF_EXISTS;
            shareflags = OPEN_ACCESS_WRITEONLY;
        }
    }
    else
    if (*mode == 'a') {
        openflags = OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS;
        shareflags = OPEN_SHARE_DENYNONE;
    }
    else
    return NULL;   /*** Error in mode-flags ***/

    shareflags |= OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYNONE;

    rc = DosOpen(filename,                    /* File path name */
                 &FileHandle,                 /* File handle */
                 &Action,                     /* Action taken */
                 0,                           /* File primary allocation */
                 FILE_NORMAL,                 /* File attribute */
                 openflags,                   /* Open function type */
                 shareflags,                  /* Open mode of the file */
                 EABUF);                      /* No extended attributes */
 
    if (rc != 0) return NULL;

    *newmode = '\0';
    strcpy(newmode,mode);
    strcat(newmode,"b");

    return fdopen(FileHandle,mode);
}

FILE *fos2open(const char *filename, const char *mode)
{   char newmode[3+1];

    *newmode = '\0';
    strcpy(newmode,mode);
    strcat(newmode,"b");

    return fopen(filename,newmode);
}


/****************************************************
 **** This function is used to change all '\'    ****
 **** characters to the '/' character. This must ****
 **** must be done to prevent the translation    ****
 **** when sprintf is used to prepare a filename ****
 ****************************************************/

void change_bsl2sl(char *changeString)
{   char *tmpptr;

    if (changeString == NULL) return;
    if (strlen(changeString) == 0) return;

    tmpptr = &changeString[0];
    while(*tmpptr != '\0')
    {   if (*tmpptr == '\\') *tmpptr = '/';
        ++tmpptr;
    }
}


/*****************************************************
 **** This function is used to change all '/'     ****
 **** characters to the '\' character. This must  ****
 **** must be done when using a prepared filename ****
 **** together with the OS/2 shell cmd or 4os2,   ****
 **** because these programs do not accept        **** 
 **** with slashes in all conditions.             **** 
 *****************************************************/

void change_sl2bsl(char *changeString)
{   char *tmpptr;

    if (changeString == NULL) return;
    if (strlen(changeString) == 0) return;

    tmpptr = &changeString[0];
    while(*tmpptr != '\0')
    {   if (*tmpptr == '/') *tmpptr = '\\';
        ++tmpptr;
    }
}


/*******************************************************
 **  this function was picked out of the SNews        **
 **  source written by John McCombs, New Zealand      **
 **   <john@ahuriri.gen.nz>. Since the first version  **
 **  most a lot has been rewritten to meet our        **
 **  requirements. The strategy how the information   **
 **  is extracted, is still the same.                 **
 *******************************************************/

int load_uupc_rc(void)
{
    /*
     *  Trawl the UUPC files to get the stuff we need - return TRUE
     *  if completed ok
     */

    int  res = 0;
    int  i;
    char buf[256];
    char *fn, *p, *v;
    FILE *tmp;


    memset(uupc_rc_settings.temp_name, '\0', 80);
    memset(uupc_rc_settings.news_dir, '\0', 80);
    memset(uupc_rc_settings.mail_dir, '\0', 80);
    memset(uupc_rc_settings.config_dir, '\0', 80);
    memset(uupc_rc_settings.mailsent, '\0', 80);
    memset(uupc_rc_settings.rmailpath, '\0', 80);
    memset(uupc_rc_settings.active, '\0', 80);
    memset(uupc_rc_settings.active_opt, '\0', 80);
    memset(uupc_rc_settings.active_times, '\0', 80);
    memset(uupc_rc_settings.user, '\0', 80);
    memset(uupc_rc_settings.mailfile, '\0', 160);
    memset(uupc_rc_settings.name, '\0', 80);
    memset(uupc_rc_settings.domain, '\0', 80);
    memset(uupc_rc_settings.site, '\0', 80);
    memset(uupc_rc_settings.organization, '\0', 80);
    memset(uupc_rc_settings.mail_server, '\0', 80);
    memset(uupc_rc_settings.editor, '\0', 80);
    memset(uupc_rc_settings.home, '\0', 80);
    memset(uupc_rc_settings.signature, '\0', 80);
    memset(uupc_rc_settings.newsadmin, '\0', 80);
    memset(uupc_rc_settings.trnlib, '\0', 80);
    memset(uupc_rc_settings.prefshell, '\0', 160);
    memset(uupc_rc_settings.locdist, '\0', 80);
    memset(uupc_rc_settings.orgdist, '\0', 80);
    memset(uupc_rc_settings.citydist, '\0', 80);
    memset(uupc_rc_settings.statedist, '\0', 80);
    memset(uupc_rc_settings.countrydist, '\0', 80);
    memset(uupc_rc_settings.continentdist, '\0', 80);

    if ((fn = getenv("COMSPEC")) == NULL) {
        fprintf(stderr, "COMSPEC environment variable undefined\n");
        return(0);
    }
    strcpy(uupc_rc_settings.prefshell, fn);
    change_sl2bsl(uupc_rc_settings.prefshell);


    /* read the system file first */
    for (i = 0; i < 3; i++) {

        /* choose the file to open */
        if (i == 0) {
            fn = getenv("UUPCSYSRC");
            if (fn == NULL) {
                fprintf(stderr, "Enviroment variable UUPCSYSRC not defined\n");
            }
        } else {
            if (i == 1) {
               fn = getenv("UUPCUSRRC");
               if (fn == NULL) {
                   fprintf(stderr, "Enviroment variable UUPCUSRRC not defined\n");
               }
            }
            else {
               fn = getenv("UUPCTRNRC");
               if (fn == NULL) {
                   fprintf(stderr, "Enviroment variable UUPCTRNRC not defined\n");
               }
            }
        }

        if (((fn != NULL) && (strlen(fn) > 1)) &&
            ((tmp = fopen(fn, "rt")) != NULL))
        {   while (fgets(buf, 83, tmp))
            {   p = strtok(buf, " =\r\n");
                if ((p == NULL) ? 0 : *p != '#')
                {   v = strtok(NULL, " =\r\n");
                    if (stricmp(p, "MailServ") == 0) {
                        strcpy(uupc_rc_settings.mail_server, v);
                        change_bsl2sl(uupc_rc_settings.mail_server);
                        res++;
                    }
                    if (stricmp(p, "FileSent") == 0) {
                        /** This setting is not required, but optional **/
                        strcpy(uupc_rc_settings.mailsent, v);
                        change_bsl2sl(uupc_rc_settings.mailsent);
                    }
                    if (stricmp(p, "NodeName") == 0) {
                        strcpy(uupc_rc_settings.site, v);
                        change_bsl2sl(uupc_rc_settings.site);
                        res++;
                    }
                    if (stricmp(p, "NewsDir") == 0) {
                        strcpy(uupc_rc_settings.news_dir, v);
                        strcpy(uupc_rc_settings.active,
                               uupc_rc_settings.news_dir);
                        strcpy(uupc_rc_settings.active_times,
                               uupc_rc_settings.news_dir);
                        strcat(uupc_rc_settings.active,"/active");
                        strcat(uupc_rc_settings.active_times,"/active.times");
                        change_bsl2sl(uupc_rc_settings.news_dir);
                        change_bsl2sl(uupc_rc_settings.active);
                        change_bsl2sl(uupc_rc_settings.active_times);
                        res++;
                    }
                    if (stricmp(p, "Domain") == 0) {
                        strcpy(uupc_rc_settings.domain, v);
                        res++;
                    }
                    if (stricmp(p, "TempDir") == 0) {
                        strcpy(uupc_rc_settings.temp_name, v);
                        change_bsl2sl(uupc_rc_settings.temp_name);
                        res++;
                    }
                    if (stricmp(p, "MailDir") == 0) {
                        strcpy(uupc_rc_settings.mail_dir, v);
                        change_bsl2sl(uupc_rc_settings.mail_dir);
                        res++;
                    }
                    if (stricmp(p, "ConfDir") == 0) {
                        strcpy(uupc_rc_settings.config_dir, v);
                        strcpy(uupc_rc_settings.active_opt,
                               uupc_rc_settings.config_dir);
                        strcat(uupc_rc_settings.active_opt,"/active");
                        change_bsl2sl(uupc_rc_settings.config_dir);
                        change_bsl2sl(uupc_rc_settings.active_opt);
                        res++;
                    }
            /*****  rmail no longer required **/
                    if (stricmp(p, "rmail") == 0) {
                        strcpy(uupc_rc_settings.rmailpath, v);
                        change_bsl2sl(uupc_rc_settings.rmailpath);
                    }
                    if (stricmp(p, "Mailbox") == 0) {
                        strcpy(uupc_rc_settings.user, v);
                        res++;
                    }
                    if (stricmp(p, "Signature") == 0) {
                        strcpy(uupc_rc_settings.signature, v);
                        change_bsl2sl(uupc_rc_settings.signature);
                        res++;
                    }
                    if (stricmp(p, "Name") == 0) {
                        strcpy(uupc_rc_settings.name, v);
                        v = strtok(NULL, " =\r\n");
                        while (v != NULL) {
                            strcat(uupc_rc_settings.name, " ");
                            strcat(uupc_rc_settings.name, v);
                            v = strtok(NULL, " =\r\n");
                        }
                        res++;
                    }
                    if (stricmp(p, "Organization") == 0) {
                        strcpy(uupc_rc_settings.organization, v);
                        v = strtok(NULL, " =\r\n");
                        while (v != NULL) {
                            strcat(uupc_rc_settings.organization, " ");
                            strcat(uupc_rc_settings.organization, v);
                            v = strtok(NULL, " =\r\n");
                        }
                        res++;
                    }
                    if (stricmp(p, "Editor") == 0) {
                        strcpy(uupc_rc_settings.editor, v);
                        res++;
                        v = strtok(NULL, " =\r\n");
                        while (v != NULL) {
                            strcat(uupc_rc_settings.editor, " ");
                            strcat(uupc_rc_settings.editor, v);
                            v = strtok(NULL, " =\r\n");
                        }
                        change_bsl2sl(uupc_rc_settings.editor);
                    }
                    if (stricmp(p, "Home") == 0) {
                        strcpy(uupc_rc_settings.home, v);
                        change_bsl2sl(uupc_rc_settings.home);
                        res++;
                    }
                    if (stricmp(p, "Newsadmin") == 0) {
                        strcpy(uupc_rc_settings.newsadmin, v);
                        res++;
                    }
                    if (stricmp(p, "TrnLib") == 0) {
                        strcpy(uupc_rc_settings.trnlib, v);
                        change_bsl2sl(uupc_rc_settings.trnlib);
                        res++;
                    }
                    if (stricmp(p, "LocalDist") == 0) {
                        strcpy(uupc_rc_settings.locdist, v);
                        res++;
                    }
                    if (stricmp(p, "OrganizationDist") == 0) {
                        strcpy(uupc_rc_settings.orgdist, v);
                        res++;
                    }
                    if (stricmp(p, "CityDist") == 0) {
                        strcpy(uupc_rc_settings.citydist, v);
                        res++;
                    }
                    if (stricmp(p, "StateDist") == 0) {
                        strcpy(uupc_rc_settings.statedist, v);
                        res++;
                    }
                    if (stricmp(p, "CountryDist") == 0) {
                        strcpy(uupc_rc_settings.countrydist, v);
                        res++;
                    }
                    if (stricmp(p, "ContinentDist") == 0) {
                        strcpy(uupc_rc_settings.continentdist, v);
                        res++;
                    }
                }
            } fclose (tmp);
        }
    }
    
    if (strlen(uupc_rc_settings.rmailpath) < 2)
    {   strcpy(uupc_rc_settings.rmailpath, "rmail.exe");
    }
    

    if (strlen(uupc_rc_settings.mail_server) < 1)
        fprintf(stderr, "Missing settings <MailServ>!\n");
    if (strlen(uupc_rc_settings.site) < 1)
        fprintf(stderr, "Missing setting <NodeName>!\n");
    if (strlen(uupc_rc_settings.news_dir) < 1)
        fprintf(stderr, "Missing setting <NewsDir>!\n");
    if (strlen(uupc_rc_settings.config_dir) < 1)
        fprintf(stderr, "Missing setting <ConfDir>\n");
    if (strlen(uupc_rc_settings.domain) < 1)
        fprintf(stderr, "Missing setting <Domain>\n");
    if (strlen(uupc_rc_settings.temp_name) < 1)
        fprintf(stderr, "Missing setting <TempDir>\n");
    if (strlen(uupc_rc_settings.mail_dir) < 1)
        fprintf(stderr, "Missing setting <MailDir>\n");
    if (strlen(uupc_rc_settings.user) < 1)
        fprintf(stderr, "Missing setting <Mailbox>\n");
    if (strlen(uupc_rc_settings.signature) < 1)
        fprintf(stderr, "Missing setting <Signature>\n");
    if (strlen(uupc_rc_settings.name) < 1)
        fprintf(stderr, "Missing setting <Name>\n");
    if (strlen(uupc_rc_settings.organization) < 1)
        fprintf(stderr, "Missing setting <Organization>\n");
    if (strlen(uupc_rc_settings.editor) < 1)
        fprintf(stderr, "Missing setting <Editor>\n");
    if (strlen(uupc_rc_settings.home) < 1)
        fprintf(stderr, "Missing setting <Home>\n");
    if (strlen(uupc_rc_settings.newsadmin) < 1)
        fprintf(stderr, "Missing setting <Newsadmin>\n");
    if (strlen(uupc_rc_settings.trnlib) < 1)
        fprintf(stderr, "Missing setting <TrnLib>\n");
    if (strlen(uupc_rc_settings.locdist) < 1)
        fprintf(stderr, "Missing setting <LocalDist>\n");
    if (strlen(uupc_rc_settings.orgdist) < 1)
        fprintf(stderr, "Missing setting <OrganizationDist>\n");
    if (strlen(uupc_rc_settings.citydist) < 1)
        fprintf(stderr, "Missing setting <CityDist>\n");
    if (strlen(uupc_rc_settings.statedist) < 1)
        fprintf(stderr, "Missing setting <StateDist>\n");
    if (strlen(uupc_rc_settings.countrydist) < 1)
        fprintf(stderr, "Missing setting <CountryDist>\n");
    if (strlen(uupc_rc_settings.continentdist) < 1)
        fprintf(stderr, "Missing setting <ContinentDist>\n");

    if (res == 21)
    {  strcpy(uupc_rc_settings.mailfile, uupc_rc_settings.mail_dir);
       strcat(uupc_rc_settings.mailfile, "/");
       strcat(uupc_rc_settings.mailfile, uupc_rc_settings.user);
    }

    return(res == 21);
}

