/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini: procedure
    window = VRWindow()

    call MMFini window

return 0

/*:VRX         Halt
*/
Halt:
    call Quit
return
/*:VRX         Init
*/
Init:
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    call MMInit window
    drop window
return
/*:VRX         PlayAndWait_Click
*/
PlayAndWait_Click:
    window = VRWindow()
    call VRSet window, "Enabled", 0
    listName = VRGet( "NowPlayingList", "Self" )
    call "PlayOne" window, listName
    call VRSet window, "Enabled", 1
return

/*:VRX         PlayNoWait_Click
*/
PlayNoWait_Click:
    window = ""       
    listName = VRGet( "NowPlayingList", "Self" )
    call VRMethod "Application", "StartThread",,
                  "PlayOne", window, listName
return

/*:VRX         Quit
*/
Quit: procedure
    window = VRWindow()
    call VRSet window, "ShutDown", 1
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

