/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window

    my_id = VRMethod( "Application", "GetThreadId" )
    call VRMethod "Application", "Post", parent_id,,
                  "call DeleteThread" my_id
    return 0

/*:VRX         Halt
*/
Halt:
    call NotifyParent
    call Quit
    return

/*:VRX         Init
*/
Init:
    window = VRWindow()
    call VRMethod window, 'CenterWindow'
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
 
    my_id = VRMethod( "Application", "GetThreadId" )
    call VRSet window, "Caption", "Thread" my_id
    call VRMethod "entryField", "SetFocus"
    drop window

    parent_id = InitArgs.1
    return
/*:VRX         NotifyParent
*/
NotifyParent:
    tid = VRMethod( "Application", "GetThreadID" )
    call VRMethod "Application", "Post",,
         "call DeleteThread " tid
return

/*:VRX         PB_1_Click
*/
PB_1_Click:
    text = VRGet( "EntryField", "Value" )
    call VRMethod "Application", "Post", parent_id,,
            "call ShowMessage", "message", text
    call VRSet "EntryField", "Value", ""
    call VRMethod "EntryField", "SetFocus"
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window2_Close
*/
Window2_Close:
    call NotifyParent
    call Quit
return

