#include "f2c.h"
#include <stdio.h>

/*
 * getenv - f77 subroutine to return environment variables
 *
 * called by:
 *	call getenv (ENV_NAME, char_var)
 * where:
 *	ENV_NAME is the name of an environment variable
 *	char_var is a character variable which will receive
 *		the current value of ENV_NAME, or all blanks
 *		if ENV_NAME is not defined
 */
#ifdef OS2
char *getenv( const char * ) ;
#endif

#ifdef KR_headers
VOID getenv_(fname, value, flen, vlen) char *value, *fname; ftnlen vlen, flen;
#else
void getenv_(char *fname, char *value, ftnlen flen, ftnlen vlen)
#endif
{
register char *ep, *fp, *flast;
#ifdef OS2
char fn[64] ;
#else
extern char **environ;
register char **env = environ;
#endif

#ifdef OS2
ep=fn ;
#endif

flast = fname + flen;
for(fp = fname ; fp < flast ; ++fp)
	if(*fp == ' ')
		{
		flast = fp;
		break;
		}
#ifdef OS2
        else *ep++ = *fp ;
*ep = '\0' ;
#endif
#ifndef OS2

while (ep = *env++)
	{
	for(fp = fname; fp<flast ; )
		if(*fp++ != *ep++)
			goto endloop;

	if(*ep++ == '=') {	/* copy right hand side */
#else
        if((ep=getenv(fn))!=NULL) {  /* use libc call */
#endif
		while( *ep && --vlen>=0 )
			*value++ = *ep++;

		goto blank;
		}
#ifndef OS2
endloop: ;
        }
#endif

blank:
	while( --vlen >= 0 )
		*value++ = ' ';
}
