/* Copyright (c) 1992 Colin Jensen.  All Rights Reserved. */


/*
 * This file was generated by the SOM Compiler.
 * FileName: ..\..\ibmh\wppalet.h.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emith: 1.11
 */

/*
 * 
 *  Module Header
 * 
 *  Module Name: WPPALET
 * 
 *  OS/2 Presentation Manager Workplace class definitions
 * 
 *  Copyright (c) International Business Machines Corporation 1991, 1992
 * 
 */


#ifndef wppalet_h
#define wppalet_h


#include <som.h>

/*
 * Define the class name as an object type
 */
#ifndef WPPalette
#define WPPalette SOMAny
#endif
#include "wpabs.h"

/*
 * Passthru lines: File: "C.h", "after"
 */

      /*
       *  Open view for the wpOpen() method
       */

      #define OPEN_PALETTE       121

      /*
       *  Palette save-restore keys
       */

      #define IDKEY_PALXCELLCOUNT      1000
      #define IDKEY_PALYCELLCOUNT      1001
      #define IDKEY_PALXCELLWIDTH      1002
      #define IDKEY_PALYCELLHEIGHT     1003
      #define IDKEY_PALXGAP            1004
      #define IDKEY_PALYGAP            1005
      #define IDKEY_PALCELLDATA_FIRST  1050

      /*
       *  Default palette information
       */

      #define DEF_XCELLCOUNT      6
      #define DEF_YCELLCOUNT      5

      /*
       *  Variables kept for each open palette window as
       *  a structure pointed to by the QWL_USER window
       *  word ...
       */

      typedef struct _CELL
      {
         ULONG       cbData;           /* Size of the data that follows */

         /* Class specific cell data follows immediately afterwards -
          * for example the font palette would store the ASCII name of
          * the font, and the color palette would store the RGB color
          * of the cell.
          */
      } CELL;
      typedef CELL *PCELL;

      typedef struct _PALINFO
      {
         ULONG       xCellCount;       /* Number of columns of cells */
         ULONG       yCellCount;       /* Number of rows of cells */
         ULONG       xCursor;          /* Cursor location (readonly) */
         ULONG       yCursor;          /* Cursor location (readonly) */
         ULONG       xCellWidth;       /* Width of each cell */
         ULONG       yCellHeight;      /* Height of each cell */
         ULONG       xGap;             /* X separation of cells */
         ULONG       yGap;             /* Y separation of cells */
      } PALINFO;
      typedef PALINFO *PPALINFO;

      #define SetPaletteDataPtr( hwnd, pPaletteData ) \
           WinSetWindowULong( hwnd, QWL_USER, (ULONG)pPaletteData )

      #define QueryPaletteDataPtr( hwnd ) \
           (PPALETTEDATA)WinQueryWindowULong( hwnd, QWL_USER )

      typedef struct _PALETTEDATA
      {
         WPFolder   *Palette;          /* Folder object for this window */
         USEITEM     UseItem;          /* Folder object's INUSE list item */
         VIEWITEM    ViewItem;
         ULONG       xCursor;
         ULONG       yCursor;
      } PALETTEDATA;
      typedef PALETTEDATA *PPALETTEDATA;

      typedef struct _CELLSTRUCT
      {
         RECTL       rclCell;          /* Cell coordinates */
         PCELL       pCell;            /* Cell data pointer */
      } CELLSTRUCT;
      typedef CELLSTRUCT *PCELLSTRUCT;
      /*
       *  Miscellaneous
       */

      #define PM_INVALIDATECELL WM_USER+1000

      /* Macros that act on a PALINFO...
       */
      #define PALETTE_WIDTH(p)  ( p.xCellCount*(p.xCellWidth+p.xGap) )
      #define PALETTE_HEIGHT(p) ( p.yCellCount*(p.yCellHeight+p.yGap) )
      #define ID_PALSCROLLHORZ     8091
      #define ID_PALSCROLLVERT     8092

      /* Coordinates (these are in DIALOG UNITS)
       */
      #define CXBUTTON          12       /* Width of a button (with no text) */
      #define CYBUTTON          12       /* Height of a button */
      #define XBUTTONGAP        6
      #define YBUTTONGAP        4
      #define CYBUTTONAREA      (CYBUTTON + 2*YBUTTONGAP)
      #define DEF_XCELLWIDTH    22
      #define DEF_YCELLHEIGHT   16
      #define DEF_XCELLGAP      4
      #define DEF_YCELLGAP      4



#define WPPalette_MajorVersion 1
#define WPPalette_MinorVersion 2

/*
 * External name shortening if required
 */
#ifdef SOM_USE_SHORT_EXTERNAL_NAMES
#define WPPaletteNewClass wppalc
#pragma linkage(wppalc, system)
#define WPPaletteClassData wppald
#define WPPaletteCClassData wppalx
#endif /* SOM_USE_SHORT_EXTERNAL_NAMES */
/*--------------Migration------------*/
#define WPPalette_classObj WPPaletteClassData.classObject
#define _WPPalette WPPalette_classObj

/*
 * New and Renew macros for WPPalette
 */
#define _WPPaletteNew() (_somNew(WPPaletteClassData.classObject))
#define WPPaletteNew() \
	( WPPaletteClassData.classObject \
		? _WPPaletteNew() \
		: ( WPPaletteNewClass(WPPalette_MajorVersion, WPPalette_MinorVersion), _WPPaletteNew() ) )
#define WPPaletteRenew(buf) \
	( _somRenew(WPPaletteClassData.classObject, buf) )

/*
 * Override method: wpInitData
 */
#define WPPalette_wpInitData(somSelf) \
	WPObject_wpInitData(somSelf)

/*
 * Override method: wpUnInitData
 */
#define WPPalette_wpUnInitData(somSelf) \
	WPObject_wpUnInitData(somSelf)

/*
 * Override method: wpSetup
 */
#define WPPalette_wpSetup(somSelf,pszSetupString) \
	WPObject_wpSetup(somSelf,pszSetupString)

/*
 * Override method: wpSaveState
 */
#define WPPalette_wpSaveState(somSelf) \
	WPObject_wpSaveState(somSelf)

/*
 * Override method: wpRestoreState
 */
#define WPPalette_wpRestoreState(somSelf,ulReserved) \
	WPObject_wpRestoreState(somSelf,ulReserved)

/*
 * Override method: wpMenuItemSelected
 */
#define WPPalette_wpMenuItemSelected(somSelf,hwndFrame,ulMenuId) \
	WPObject_wpMenuItemSelected(somSelf,hwndFrame,ulMenuId)

/*
 * Override method: wpModifyPopupMenu
 */
#define WPPalette_wpModifyPopupMenu(somSelf,hwndMenu,hwndCnr,iPosition) \
	WPObject_wpModifyPopupMenu(somSelf,hwndMenu,hwndCnr,iPosition)

/*
 * Override method: wpFilterPopupMenu
 */
#define WPPalette_wpFilterPopupMenu(somSelf,ulFlags,hwndCnr,fMultiSelect) \
	WPObject_wpFilterPopupMenu(somSelf,ulFlags,hwndCnr,fMultiSelect)

/*
 * Override method: wpOpen
 */
#define WPPalette_wpOpen(somSelf,hwndCnr,ulView,param) \
	WPObject_wpOpen(somSelf,hwndCnr,ulView,param)

/*
 * Override method: wpMenuItemHelpSelected
 */
#define WPPalette_wpMenuItemHelpSelected(somSelf,MenuId) \
	WPObject_wpMenuItemHelpSelected(somSelf,MenuId)

/*
 * New Method: wpPaintCell
 */
typedef VOID    SOMLINK somTP_WPPalette_wpPaintCell(WPPalette *somSelf,
		PCELL pCell,
		HPS hps,
		PRECTL prcl,
		BOOL fHilite);
#pragma linkage(somTP_WPPalette_wpPaintCell, system)
typedef somTP_WPPalette_wpPaintCell *somTD_WPPalette_wpPaintCell;
#define somMD_WPPalette_wpPaintCell "----"
#define WPPalette_wpPaintCell(somSelf,pCell,hps,prcl,fHilite) \
    (SOM_Resolve(somSelf, WPPalette, wpPaintCell) \
	(somSelf,pCell,hps,prcl,fHilite))
#define _wpPaintCell WPPalette_wpPaintCell

/*
 * New Method: wpSetupCell
 */
typedef BOOL    SOMLINK somTP_WPPalette_wpSetupCell(WPPalette *somSelf,
		PVOID pCellData,
		ULONG cb,
		ULONG x,
		ULONG y);
#pragma linkage(somTP_WPPalette_wpSetupCell, system)
typedef somTP_WPPalette_wpSetupCell *somTD_WPPalette_wpSetupCell;
#define somMD_WPPalette_wpSetupCell "----"
#define WPPalette_wpSetupCell(somSelf,pCellData,cb,x,y) \
    (SOM_Resolve(somSelf, WPPalette, wpSetupCell) \
	(somSelf,pCellData,cb,x,y))
#define _wpSetupCell WPPalette_wpSetupCell

/*
 * New Method: wpRedrawCell
 */
typedef BOOL    SOMLINK somTP_WPPalette_wpRedrawCell(WPPalette *somSelf,
		PCELL pCell);
#pragma linkage(somTP_WPPalette_wpRedrawCell, system)
typedef somTP_WPPalette_wpRedrawCell *somTD_WPPalette_wpRedrawCell;
#define somMD_WPPalette_wpRedrawCell "----"
#define WPPalette_wpRedrawCell(somSelf,pCell) \
    (SOM_Resolve(somSelf, WPPalette, wpRedrawCell) \
	(somSelf,pCell))
#define _wpRedrawCell WPPalette_wpRedrawCell

/*
 * New Method: wpQueryPaletteInfo
 */
typedef BOOL    SOMLINK somTP_WPPalette_wpQueryPaletteInfo(WPPalette *somSelf,
		PPALINFO pPalInfo);
#pragma linkage(somTP_WPPalette_wpQueryPaletteInfo, system)
typedef somTP_WPPalette_wpQueryPaletteInfo *somTD_WPPalette_wpQueryPaletteInfo;
#define somMD_WPPalette_wpQueryPaletteInfo "----"
#define WPPalette_wpQueryPaletteInfo(somSelf,pPalInfo) \
    (SOM_Resolve(somSelf, WPPalette, wpQueryPaletteInfo) \
	(somSelf,pPalInfo))
#define _wpQueryPaletteInfo WPPalette_wpQueryPaletteInfo

/*
 * New Method: wpSetPaletteInfo
 */
typedef BOOL    SOMLINK somTP_WPPalette_wpSetPaletteInfo(WPPalette *somSelf,
		PPALINFO pPalInfo);
#pragma linkage(somTP_WPPalette_wpSetPaletteInfo, system)
typedef somTP_WPPalette_wpSetPaletteInfo *somTD_WPPalette_wpSetPaletteInfo;
#define somMD_WPPalette_wpSetPaletteInfo "----"
#define WPPalette_wpSetPaletteInfo(somSelf,pPalInfo) \
    (SOM_Resolve(somSelf, WPPalette, wpSetPaletteInfo) \
	(somSelf,pPalInfo))
#define _wpSetPaletteInfo WPPalette_wpSetPaletteInfo

/*
 * New Method: wpEditCell
 */
typedef BOOL    SOMLINK somTP_WPPalette_wpEditCell(WPPalette *somSelf,
		PCELL pCell,
		HWND hwndPal);
#pragma linkage(somTP_WPPalette_wpEditCell, system)
typedef somTP_WPPalette_wpEditCell *somTD_WPPalette_wpEditCell;
#define somMD_WPPalette_wpEditCell "----"
#define WPPalette_wpEditCell(somSelf,pCell,hwndPal) \
    (SOM_Resolve(somSelf, WPPalette, wpEditCell) \
	(somSelf,pCell,hwndPal))
#define _wpEditCell WPPalette_wpEditCell

/*
 * New Method: wpDragCell
 */
typedef BOOL    SOMLINK somTP_WPPalette_wpDragCell(WPPalette *somSelf,
		PCELL pCell,
		HWND hwndPal,
		PPOINTL ptlDrag);
#pragma linkage(somTP_WPPalette_wpDragCell, system)
typedef somTP_WPPalette_wpDragCell *somTD_WPPalette_wpDragCell;
#define somMD_WPPalette_wpDragCell "----"
#define WPPalette_wpDragCell(somSelf,pCell,hwndPal,ptlDrag) \
    (SOM_Resolve(somSelf, WPPalette, wpDragCell) \
	(somSelf,pCell,hwndPal,ptlDrag))
#define _wpDragCell WPPalette_wpDragCell

/*
 * New Method: wpQueryPaletteHelp
 */
typedef ULONG    SOMLINK somTP_WPPalette_wpQueryPaletteHelp(WPPalette *somSelf);
#pragma linkage(somTP_WPPalette_wpQueryPaletteHelp, system)
typedef somTP_WPPalette_wpQueryPaletteHelp *somTD_WPPalette_wpQueryPaletteHelp;
#define somMD_WPPalette_wpQueryPaletteHelp "----"
#define WPPalette_wpQueryPaletteHelp(somSelf) \
    (SOM_Resolve(somSelf, WPPalette, wpQueryPaletteHelp) \
	(somSelf))
#define _wpQueryPaletteHelp WPPalette_wpQueryPaletteHelp

/*
 * Declare the class creation procedure
 */
SOMEXTERN SOMAny * SOMLINK WPPaletteNewClass(integer4 scemajorVersion,
		integer4 sceminorVersion);
#pragma linkage(WPPaletteNewClass, system)

/*
 * Declare the class data structure
 */
SOMEXTERN struct WPPaletteClassDataStructure {
	SOMAny *classObject;
	somMToken wpPaintCell;
	somMToken wpSelectCell;
	somMToken wpSetupCell;
	somMToken wpQueryPaletteInfo;
	somMToken wpSetPaletteInfo;
	somMToken wpEditCell;
	somMToken wpDragCell;
	somMToken withdrawn;
	somMToken wpInitCellStructs;
	somMToken wpRedrawCell;
	somMToken wpPaintPalette;
	somMToken wpMouseAction;
	somMToken wpQueryPaletteHelp;
	somMToken wpShowPalettePointer;
} WPPaletteClassData;

/*
 * Declare the C specific class data structure
 */
SOMEXTERN struct WPPaletteCClassDataStructure {
	somMethodTab *parentMtab;
	somDToken instanceDataToken;
} WPPaletteCClassData;

#endif       /* wppalet_h */

/*
 * This file was generated by the SOM Compiler.
 * FileName: ..\..\ibmh\wppalet.h.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emith: 1.11
 */

#ifndef wppalet_mh
#define wppalet_mh


/*
 * Define the class name as an object type
 */
#ifndef M_WPPalette
#define M_WPPalette SOMAny
#endif

#define M_WPPalette_MajorVersion 1
#define M_WPPalette_MinorVersion 2

/*
 * External name shortening if required
 */
#ifdef SOM_USE_SHORT_EXTERNAL_NAMES
#define M_WPPaletteNewClass wppalc
#pragma linkage(wppalc, system)
#define M_WPPaletteClassData wppald
#define M_WPPaletteCClassData wppalx
#endif /* SOM_USE_SHORT_EXTERNAL_NAMES */
/*--------------Migration------------*/
#define M_WPPalette_classObj M_WPPaletteClassData.classObject
#define _M_WPPalette M_WPPalette_classObj

/*
 * New and Renew macros for M_WPPalette
 */
#define _M_WPPaletteNew() (_somNew(M_WPPaletteClassData.classObject))
#define M_WPPaletteNew() \
	( M_WPPaletteClassData.classObject \
		? _M_WPPaletteNew() \
		: ( M_WPPaletteNewClass(M_WPPalette_MajorVersion, M_WPPalette_MinorVersion), _M_WPPaletteNew() ) )
#define M_WPPaletteRenew(buf) \
	( _somRenew(M_WPPaletteClassData.classObject, buf) )

/*
 * Override method: wpclsQueryTitle
 */
#define M_WPPalette_wpclsQueryTitle(somSelf) \
	M_WPObject_wpclsQueryTitle(somSelf)

/*
 * Override method: wpclsQueryStyle
 */
#define M_WPPalette_wpclsQueryStyle(somSelf) \
	M_WPObject_wpclsQueryStyle(somSelf)

/*
 * Override method: wpclsQueryDefaultView
 */
#define M_WPPalette_wpclsQueryDefaultView(somSelf) \
	M_WPObject_wpclsQueryDefaultView(somSelf)

/*
 * Override method: wpclsQueryDefaultHelp
 */
#define M_WPPalette_wpclsQueryDefaultHelp(somSelf,pHelpPanelId,pszHelpLibrary) \
	M_WPObject_wpclsQueryDefaultHelp(somSelf,pHelpPanelId,pszHelpLibrary)

/*
 * New Method: wpclsQueryEditString
 */
typedef PSZ    SOMLINK somTP_M_WPPalette_wpclsQueryEditString(M_WPPalette *somSelf);
#pragma linkage(somTP_M_WPPalette_wpclsQueryEditString, system)
typedef somTP_M_WPPalette_wpclsQueryEditString *somTD_M_WPPalette_wpclsQueryEditString;
#define somMD_M_WPPalette_wpclsQueryEditString "----"
#define M_WPPalette_wpclsQueryEditString(somSelf) \
    (SOM_Resolve(somSelf, M_WPPalette, wpclsQueryEditString) \
	(somSelf))
#define _wpclsQueryEditString M_WPPalette_wpclsQueryEditString

/*
 * Declare the class creation procedure
 */
SOMEXTERN SOMAny * SOMLINK M_WPPaletteNewClass(integer4 scemajorVersion,
		integer4 sceminorVersion);
#pragma linkage(M_WPPaletteNewClass, system)

/*
 * Declare the class data structure
 */
SOMEXTERN struct M_WPPaletteClassDataStructure {
	SOMAny *classObject;
	somMToken wpclsQueryEditString;
} M_WPPaletteClassData;

/*
 * Declare the C specific class data structure
 */
SOMEXTERN struct M_WPPaletteCClassDataStructure {
	somMethodTab *parentMtab;
	somDToken instanceDataToken;
} M_WPPaletteCClassData;

#endif       /* wppalet_h */
