
/*
     Program PM-Info: a program for viewing GNU-style hypertext info
     documentation files.
     Copyright (C) 1992,1993  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@ampex.com or ljensen@netcom.netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/

#include <stdlib.h>
#define INCL_PM
#include <os2.h>
#include "stddia.h"
#ifndef NDEBUG
#define NDEBUG
#endif
#include "bugme.h"

//#define SERIOUS_DEBUG

void *object_to_call;

StdDialogBaseClass::StdDialogBaseClass()
    : item_list(NULL)
{
    BUGME(("StdDialogBaseClass[%X]::StdDialogBaseClass()", this));
}

void StdDialogBaseClass::RegisterItem(StdDialogItemClass *item)
{
    BUGME(("StdDialogBaseClass[%X]::RegisterItem(%X)", this, item));
    item->next = item_list;
    item_list = item;
}

MRESULT StdDialogBaseClass::message(HWND win, int msg, MPARAM mp1, MPARAM mp2)
{
#ifdef SERIOUS_DEBUG
    BUGME(("StdDialogBaseClass[%X]::message(%d,%X,%X,%X)", this,
	   win, msg, mp1, mp2));
#endif
    int default_needed = 1;
    int accept_msg;
    MRESULT return_code=0, code;
    StdDialogItemClass *item;

    if (msg == WM_INITDLG) {
	// Validate the hwnd on init
	is_hwnd_availible = 1;
	current_hwnd = win;
    }
    for (item = item_list; item != NULL; item = item->next) {
#ifdef SERIOUS_DEBUG
	BUGME(("StdDialogBaseClass[%X]::message:  Passing message to %X",
	       this, item));
#endif
	accept_msg = 0;
#ifdef SERIOUS_DEBUG
	BUGME(("StdDialogBaseClass::message: calling item %08X", item));
#endif
	code = CALL_METHOD(item, message, (msg, mp1, mp2, &accept_msg));
#ifdef SERIOUS_DEBUG
	BUGME(("StdDialogBaseClass::message: returned from item"));
#endif
	if (accept_msg) {
	    default_needed = 0;
	    return_code = code;
	}
    }
    if (msg == WM_CLOSE) {
	// Invalidate the hwnd on close
	is_hwnd_availible = 0;
    }
    if (default_needed) {
	BUGME(("StdDialogBaseClass::message: calling WinDefDlgProc"));
	MRESULT result =  WinDefDlgProc(win, msg, mp1, mp2);
	BUGME(("StdDialogBaseClass::message: returning %d", result));
	return result;
    } else {
	return return_code;
    }
}

StdDialogClass::StdDialogClass(int adialog_id)
    : StdDialogBaseClass(),
      dialog_id(adialog_id),
      StdDialogInitClass(this)
{
    BUGME(("StdDialogClass[%X]::StdDialogClass(%d)", this, adialog_id));
}

StdDialogClass *StdDialogClass::current_dialog = NULL;

MRESULT StdDialogClass::message_thunk(HWND win, int msg, MPARAM mp1, 
					  MPARAM mp2)
{
#ifdef SERIOUS_DEBUG
    BUGME(("StdDialogClass[static]::message_thunk(...)"));
#endif
    if (current_dialog != NULL) {
	return current_dialog->message(win, msg, mp1, mp2);
    } else {
	return WinDefDlgProc(win, msg, mp1, mp2);
    }
}

void StdDialogClass::ExecDialog(HWND owner)
{
    BUGME(("StdDialogClass[%X]::ExecDialog(%d)", this, owner));
    current_dialog = this;
    WinDlgBox(HWND_DESKTOP, owner, message_thunk, 0, dialog_id, NULL);
}

StdDialogItemClass::StdDialogItemClass(int adialog_id, 
				       StdDialogBaseClass *adialog_base)
    : dialog_id(adialog_id), dialog_base(adialog_base)
{
    BUGME(("StdDialogItemClass[%X]::StdDialogItemClass(%d)", this, 
	   adialog_id));
    OVERRIDE_METHOD(message);
    dialog_base->RegisterItem(this);
}

MRESULT StdDialogItemClass::SendMsg(int msg, MPARAM mp1, MPARAM mp2)
{
    if (!dialog_base->hwnd_availible()) return (MRESULT) -1;
    return WinSendDlgItemMsg(dialog_base->hwnd(), dialog_id, msg, mp1, mp2);
}

DEFINE_METHOD(StdDialogItemClass, message, MRESULT, 
	      (int msg, MPARAM mp1, MPARAM mp2, int *accept_msg),
	      (msg, mp1, mp2, accept_msg));

MRESULT StdDialogItemClass::message(int, MPARAM, MPARAM, int *)
{
#ifdef SERIOUS_DEBUG
    BUGME(("StdDialogItemClass[%X]::message(...)"));
#endif
    return 0;
}

StdDialogInitClass::StdDialogInitClass(StdDialogBaseClass *adialog_base)
    : StdDialogItemClass(0, adialog_base)
{
    BUGME(("StdDialogInitClass[%X]::StdDialogInitClass()"));
    OVERRIDE_METHOD(message);
}

DEFINE_METHOD(StdDialogInitClass, message, MRESULT, 
	      (int msg, MPARAM mp1, MPARAM mp2, int *accept_msg),
	      (msg, mp1, mp2, accept_msg));

MRESULT StdDialogInitClass::message(int msg, MPARAM, MPARAM, int *)
{
#ifdef SERIOUS_DEBUG
    BUGME(("StdDialogInitClass[%X]::message(...)", this));
#endif
    switch(msg) {
    case WM_INITDLG:
	dialog_init();
	break;
    }
    return 0;
}

void StdDialogInitClass::dialog_init()
{
    BUGME(("StdDialogInitClass[%X]::dialog_init", this));
}

StdMessageItemClass::StdMessageItemClass(StdDialogBaseClass *adialog_base,
					 int amessage_id)
    : StdDialogItemClass(0, adialog_base),
      message_id(amessage_id)
{
    BUGME(("StdMessageItemClass[%X]::StdMessageItemClass(%d)", this, 
	   amessage_id));
    OVERRIDE_METHOD(message);
    OVERRIDE_METHOD(cmd_message);
}

void StdMessageItemClass::cmd_message()
{
    BUGME(("StdMessageItemClass[%X]::cmd_message", this));
}

DEFINE_METHOD(StdMessageItemClass, message, MRESULT, 
	      (int msg, MPARAM mp1, MPARAM mp2, int *accept_msg),
	      (msg, mp1, mp2, accept_msg));

DEFINE_VOID_METHOD(StdMessageItemClass, cmd_message, (), ());

MRESULT StdMessageItemClass::message(int msg, MPARAM mp1, MPARAM mp2,
				     int *accept_msg)
{
#ifdef SERIOUS_DEBUG
    BUGME(("StdMessageItemClass[%X]::message(...)", this));
#endif
    switch(msg) {
    case WM_COMMAND:
	if (SHORT1FROMMP(mp1) == message_id) {
	    CALL_METHOD(this, cmd_message, ());
	    return 0;
	}
    }
    return 0;
}


StdOKMessageItemClass::StdOKMessageItemClass(StdDialogBaseClass *adialog_base)
    : StdMessageItemClass(adialog_base, DID_OK)
{
    BUGME(("StdOKMessageItemClass[%X]::StdOKMessageItemClass", this));
    OVERRIDE_METHOD(cmd_message)
}

DEFINE_VOID_METHOD(StdOKMessageItemClass, cmd_message, (), ());

void StdOKMessageItemClass::cmd_message()
{
    BUGME(("StdOKMessageItemClass[%X]::cmd_message()", this));
    ok_message();
}

StdCancelMessageItemClass::StdCancelMessageItemClass(StdDialogBaseClass 
						     *adialog_base)
    : StdMessageItemClass(adialog_base, DID_CANCEL)
{
    BUGME(("StdCancelMessageItemClass[%X]::StdCancelMessageItemClass()", 
	   this));
    OVERRIDE_METHOD(cmd_message);
}

DEFINE_VOID_METHOD(StdCancelMessageItemClass, cmd_message, (), ());

void StdCancelMessageItemClass::cmd_message()
{
    BUGME(("StdCancelMessageItemClass[%X]::cmd_message()", this));
    cancel_message();
}


StdListBoxItemClass::StdListBoxItemClass(int adialog_id, 
					 StdDialogBaseClass *adialog_base)
    : StdDialogItemClass(adialog_id, adialog_base)
{
    BUGME(("StdListBoxItemClass[%X]::StdListBoxItemClass(%d)", this,
	   adialog_id));
    OVERRIDE_METHOD(message);
    OVERRIDE_METHOD(select);
}

DEFINE_METHOD(StdListBoxItemClass, message, MRESULT, 
	      (int msg, MPARAM mp1, MPARAM mp2, int *accept_msg),
	      (msg, mp1, mp2, accept_msg));
DEFINE_VOID_METHOD(StdListBoxItemClass, select, (), ());

MRESULT StdListBoxItemClass::message(int msg, MPARAM mp1, MPARAM mp2, 
				     int *accept_msg)
{
#ifdef SERIOUS_DEBUG
    BUGME(("StdListBoxItemClass[%X]::message(...)", this));
#endif
    switch(msg) {
    case WM_CONTROL:
	if (SHORT1FROMMP(mp1) == dialog_id) {
	    switch(SHORT2FROMMP(mp1)) {
	    case LN_SELECT:
		CALL_METHOD(this, select, ());
		*accept_msg = 1;
		break;
	    }
	}
    }
    return 0;
}

void StdListBoxItemClass::select()
{
}

void StdListBoxItemClass::insert(int index, const char *text)
{
    BUGME(("StdListBoxItemClass[%X]::insert(%d, %s)", this, index, text));
    if (!dialog_base->hwnd_availible()) return;
    SendMsg(LM_INSERTITEM, MPFROMSHORT(index), MPFROMP(text));
}

void StdListBoxItemClass::insert_at_end(const char *text)
{
    BUGME(("StdListBoxItemClass[%X]::insert_at_end(%s)", this, text));
    insert(LIT_END, text);
}

void StdListBoxItemClass::insert_order_ascending(const char *text)
{
    BUGME(("StdListBoxItemClass[%X]::insert_at_ascending(%s)", this, text));
    insert(LIT_SORTASCENDING, text);
}

void StdListBoxItemClass::insert_order_descending(const char *text)
{
    BUGME(("StdListBoxItemClass[%X]::insert_at_descending(%s)", this, text));
    insert(LIT_SORTDESCENDING, text);
}

void StdListBoxItemClass::select_item(int index)
{
    BUGME(("StdListBoxItemClass::select_item(%d)", index));
#ifdef DEBUG
    int code = (int)
#endif
	SendMsg(LM_SELECTITEM, MPFROMSHORT(index), MPFROMSHORT(TRUE));
    BUGME(("StdListBoxItemClass::select_item: returns %d", code));
}

void StdListBoxItemClass::delete_all()
{
    SendMsg(LM_DELETEALL, NULL, NULL);
}

int StdListBoxItemClass::query_selection()
{
    return (int) SendMsg(LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), NULL);
}

int StdListBoxItemClass::query_selection_exists()
{
    return query_selection() != LIT_NONE;
}

char *StdListBoxItemClass::query_item_text(int item)
{
    int length = (int) SendMsg(LM_QUERYITEMTEXTLENGTH, 
			       MPFROMSHORT(item), NULL);
    if (length == LIT_ERROR) return NULL;

    char *ret_buf = (char *) malloc(length+1);
    if (ret_buf == NULL) return NULL;

    SendMsg(LM_QUERYITEMTEXT, MPFROM2SHORT(item, length+1), MPFROMP(ret_buf));
    return ret_buf;
}

char *StdListBoxItemClass::query_selection_text()
{
    if (!query_selection_exists()) return NULL;
    return query_item_text(query_selection());
}

StdComboBoxItemClass::StdComboBoxItemClass(int adialog_id, 
					   StdDialogBaseClass *adialog_class)
    : StdListBoxItemClass(adialog_id, adialog_class)
{
    OVERRIDE_METHOD(message);
    OVERRIDE_METHOD(entry_field_changed);
}

DEFINE_METHOD(StdComboBoxItemClass, message, MRESULT,
	      (int msg, MPARAM mp1, MPARAM mp2, int *accept_msg),
	      (msg, mp1, mp2, accept_msg));
DEFINE_VOID_METHOD(StdComboBoxItemClass, entry_field_changed, (), ());

MRESULT StdComboBoxItemClass::message(int msg, MPARAM mp1, MPARAM mp2,
				      int *accept_msg)
{
    int accept = 0;
    StdListBoxItemClass::message(msg, mp1, mp2, &accept);
    switch(msg) {
    case WM_CONTROL:
	BUGME(("StdComboBoxItemClass[%X]::message(WM_CONTROL, %08X, %08X)",
	       this,
	       mp1, mp2));
	if (SHORT1FROMMP(mp1) == dialog_id) {
	    BUGME(("StdComboBoxItemClass::message: Correct dialog id!"));
	    switch(SHORT2FROMMP(mp1)) {
	    case CBN_EFCHANGE:
		CALL_METHOD(this, entry_field_changed, ());
		*accept_msg = 1;
		break;
	    }
	}
	break;
    }
    if (accept) *accept_msg = 1;
    return 0;
}

void StdComboBoxItemClass::entry_field_changed()
{
    BUGME(("StdComboBoxItemClass::entry_field_changed()"));
}
