
/*
     Program PM-Info: a program for viewing GNU-style hypertext info
     documentation files.
     Copyright (C) 1992,1993  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/

#include <ctype.h>

#define INCL_WIN
#include <os2.h>

#include "stdwin.h"
#ifndef NDEBUG
#define NDEBUG
#endif
#include "bugme.h"

#include "pminfo.h"  // If this class was better, we wouldn't need this


StdWin *StdWin::stdwinlist = NULL;
StdWin *StdWin::new_window_object = NULL;

#define MK_MSG(MSG, msg)						      \
MRESULT StdWin::Msg##msg(MPARAM, MPARAM, int *dodefault)		      \
{									      \
    *dodefault = 1;							      \
    return 0;								      \
}
#include "msg.h"

#define MK_MSG(MSG, msg)						      \
void StdWin::DebugMsg##msg(MPARAM, MPARAM)				      \
{									      \
    BUGME(("Message: " #MSG));						      \
}
#include "msg.h"

#if 0
MRESULT StdWin::MsgPaint(MPARAM, MPARAM, int *)
{
    // By default, draw a blank window
    HPS hps = WinBeginPaint(window, NULL, NULL);
    GpiErase(hps);
    WinEndPaint(hps);
    return 0;
}
#endif

StdWin::StdWin(void)
{
}

void StdWin::Init(HAB hab, const char *classname, ULONG message_flags,
	ULONG frame_flags)
{
    // Insert self into list of event windows
    stdwinlist_next = stdwinlist;
    stdwinlist = this;

    // Register the class with PM
    static int is_registered = 0;
    if (!is_registered) {
	is_registered = 1;
	WinRegisterClass(hab, (PSZ)classname, ClientWndProcWhack,
		message_flags, 0);
    }

    BUGME(("About to instantiate a window"));
    new_window_object = this;
    HWND window_lossage = (HWND) -1;
    window = (HWND) -1;
    // Then instantiate ourself
    frame = WinCreateStdWindow(HWND_DESKTOP, WS_VISIBLE, &frame_flags,
	(PSZ)classname, NULL, 0L, 0, ID_RESOURCE, &window_lossage);
    new_window_object = NULL;
    if (window_lossage != window) {
	// We really are in trouble if we get here!
	// (but if a virtual function messes up- then this could happen)
	window = window_lossage;
	BUGME(("Something really bad happened - expect a crash"));
	BUGME(("Lossage notes: window=%ld window_lossage=%ld"));
    }
    BUGME(("instantiation done"));

/*
    WinSendMsg(frame, WM_SETICON,
	(void *) WinQuerySysPointer(HWND_DESKTOP, SPTR_APPICON, FALSE),
	NULL);
*/
}

void StdWin::Destroy(void)
{
    WinDestroyWindow(frame);
}

MRESULT StdWin::ClientWndProcWhack(HWND window, USHORT msg, MPARAM mp1,
				   MPARAM mp2)
{
    StdWin *target_window;
    BUGME(("StdWin::ClientWndProcWack(%ld, ...)", (long) window));
    // Locate ourself in the list of existing windows, and exec ourself
    for (target_window = stdwinlist; target_window != NULL;
	target_window = target_window->stdwinlist_next) {
	BUGME(("Trying to match window %ld", (long) target_window->window));
	if (target_window->window == window) 
	    return target_window->ClientWndProc(msg, mp1, mp2);
    }

    // PM Lossage: PM does not assign the window field *before* sending
    // the first message.  This is so brain dead it reminds me of X11.
    // PM seems to assign a window of -1 when it does this stupidity.
    // Also, the first message is always WM_CREATE
    // [Should I continue to rely on the -1? I can get by without it]
    if (new_window_object != NULL && msg == WM_CREATE) {
	BUGME(("Searching for PM WM_CREATE lossage"));
	BUGME(("...Searching for window %d", new_window_object));
	for (target_window = stdwinlist; target_window != NULL;
	     target_window = target_window->stdwinlist_next) {
	    BUGME(("Checking window %d with id %d", target_window, 
		   target_window->window));
	    if (new_window_object == target_window 
		&& target_window->window == -1) {
		BUGME(("Target found... fixing lossage"));
		target_window->window = window;  // PM should do this!
		return target_window->ClientWndProc(msg, mp1, mp2);
	    }
	}
    }

    // We really should never fall thru this loop, but just in case
    return WinDefWindowProc(window, msg, mp1, mp2);
}

MRESULT StdWin::ClientWndProc(USHORT msg, MPARAM mp1, MPARAM mp2)
{
    BUGME(("StdWin::ClientWndProc(...)"));
    int dodefault = 0;
    MRESULT result = 0;
    switch(msg) {
#define MK_MSG(MSG_TYPE, msg_name)					      \
    case WM_##MSG_TYPE:							      \
	DebugMsg##msg_name(mp1, mp2);					      \
	result = Msg##msg_name(mp1, mp2, &dodefault);			      \
	break;
#include "msg.h"
    default:
	BUGME(("Client Proc: MSG 0x%04X", msg));
	dodefault = 1;
    }
    return (dodefault) ? WinDefWindowProc(window, msg, mp1, mp2) : result;
}

HAB StdWin::hab;
HMQ StdWin::hmq;

void StdWin::StdStartup()
{
    hab = WinInitialize(0);
    hmq = WinCreateMsgQueue(hab, 0);
}

void StdWin::StdMainLoop()
{
    QMSG qmsg;
    while (WinGetMsg(hab, &qmsg, 0, 0, 0)) {
	WinDispatchMsg(hab, &qmsg);
    }
}

void StdWin::StdExit()
{
    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);
}


//****
//**** Start of StdWinPlus class
//****


StdWinPlus::StdWinPlus()
    : StdWin()
{
}

void StdWinPlus::DebugMsgChar(MPARAM mp1, MPARAM mp2)
{
#ifdef DEBUG
#if 0
    inherited::
#else
      StdWin::
#endif
    DebugMsgChar(mp1, mp2);

    USHORT fsflags = SHORT1FROMMP(mp1);
    UCHAR ucrepeat = CHAR3FROMMP(mp1);
    UCHAR ucscancode = CHAR4FROMMP(mp1);

    USHORT usch = SHORT1FROMMP(mp2);
    USHORT usvk = SHORT2FROMMP(mp2);


    tell("CharMsg:");
    tell("char: fsflags [%04lX]", (long) fsflags);
#define FOO(f) if (fsflags & f) tell("\t" #f);
    FOO(KC_CHAR);
    FOO(KC_SCANCODE);
    FOO(KC_VIRTUALKEY);
    FOO(KC_KEYUP);
    FOO(KC_PREVDOWN);
    FOO(KC_DEADKEY);
    FOO(KC_COMPOSITE);
    FOO(KC_INVALIDCOMP);
    FOO(KC_LONEKEY);
    FOO(KC_SHIFT);
    FOO(KC_ALT);
    FOO(KC_CTRL);
#undef FOO
    if (isprint(usch)) tell("\tchar: '%c'", usch);

    tell("char: ucrepeat [%02lX]", (long) ucrepeat);
    tell("char: ucscancode [%02lX]", (long) ucscancode);
    tell("char: usch [%02lX]", (long) usch);
    switch(usvk) {
#define FOO(VK) case VK: tell("\tvirtual key: " #VK); break
	FOO(VK_BUTTON1);
	FOO(VK_BUTTON2);
	FOO(VK_BUTTON3);
	FOO(VK_BREAK);
	FOO(VK_BACKSPACE);
	FOO(VK_TAB);
	FOO(VK_BACKTAB);
	FOO(VK_NEWLINE);
	FOO(VK_SHIFT);
	FOO(VK_CTRL);
	FOO(VK_ALT);
	FOO(VK_ALTGRAF);
	FOO(VK_PAUSE);
	FOO(VK_CAPSLOCK);
	FOO(VK_ESC);
	FOO(VK_SPACE);
	FOO(VK_PAGEUP);
	FOO(VK_PAGEDOWN);
	FOO(VK_END);
	FOO(VK_HOME);
	FOO(VK_LEFT);
	FOO(VK_UP);
	FOO(VK_RIGHT);
	FOO(VK_DOWN);
	FOO(VK_PRINTSCRN);
	FOO(VK_INSERT);
	FOO(VK_DELETE);
	FOO(VK_SCRLLOCK);
	FOO(VK_NUMLOCK);
	FOO(VK_ENTER);
	FOO(VK_SYSRQ);
	FOO(VK_F1);
	FOO(VK_F2);
	FOO(VK_F3);
	FOO(VK_F4);
	FOO(VK_F5);
	FOO(VK_F6);
	FOO(VK_F7);
	FOO(VK_F8);
	FOO(VK_F9);
	FOO(VK_F10);
	FOO(VK_F11);
	FOO(VK_F12);
	FOO(VK_F13);
	FOO(VK_F14);
	FOO(VK_F15);
	FOO(VK_F16);
	FOO(VK_F17);
	FOO(VK_F18);
	FOO(VK_F19);
	FOO(VK_F20);
	FOO(VK_F21);
	FOO(VK_F22);
	FOO(VK_F23);
	FOO(VK_F24);
    default:
	tell("char: usvk [%02lX]", (long) usvk);
	break;
    }
#endif
}

MRESULT StdWinPlus::MsgPaint(MPARAM, MPARAM, int *dodefault)
{
    return MsgPaint(dodefault);
}

MRESULT StdWinPlus::MsgPaint(int *dodefault)
{
    *dodefault = 1;
    return 0;
}

MRESULT StdWinPlus::MsgSize(MPARAM mp1, MPARAM mp2, int *dodefault)
{
    return MsgSize(SHORT1FROMMP(mp1), SHORT2FROMMP(mp1),
		   SHORT1FROMMP(mp2), SHORT2FROMMP(mp2),
		   dodefault);
		   
}
MRESULT StdWinPlus::MsgSize(SHORT, SHORT, SHORT, SHORT, int *dodefault)
{
    *dodefault = 1;
    return 0;
}

MRESULT StdWinPlus::MsgCreate(MPARAM mp1, MPARAM mp2, int *dodefault)
{
    return MsgCreate(PVOIDFROMMP(mp1), (PCREATESTRUCT) PVOIDFROMMP(mp2), 
		     dodefault);
}
MRESULT StdWinPlus::MsgCreate(PVOID, PCREATESTRUCT, int *dodefault)
{
    *dodefault = 1;
    return 0;
}

MRESULT StdWinPlus::MsgVscroll(MPARAM mp1, MPARAM mp2, int *dodefault)
{
    return MsgVscroll(SHORT1FROMMP(mp1), SHORT1FROMMP(mp2), SHORT2FROMMP(mp2),
		      dodefault);
}
MRESULT StdWinPlus::MsgVscroll(USHORT, SHORT, USHORT, int *dodefault)
{
    *dodefault = 1;
    return 0;
}

MRESULT StdWinPlus::MsgButton1Down(MPARAM mp1, MPARAM mp2, int *dodefault)
{
    // Ain't Standard C fun?
    return MsgButton1Down(* (POINTS *) (void *) &mp1, SHORT1FROMMP(mp2), 
			  SHORT2FROMMP(mp2), dodefault);
}
MRESULT StdWinPlus::MsgButton1Down(POINTS, USHORT, USHORT, int *dodefault)
{
    *dodefault = 1;
    return 0;
}

MRESULT StdWinPlus::MsgCommand(MPARAM mp1, MPARAM mp2, int *dodefault)
{
    return MsgCommand(SHORT1FROMMP(mp1), SHORT1FROMMP(mp2), SHORT2FROMMP(mp2),
		      dodefault);
}
MRESULT StdWinPlus::MsgCommand(USHORT, USHORT, USHORT, int *dodefault)
{
    *dodefault = 1;
    return 0;
}

MRESULT StdWinPlus::MsgPresParamChanged(MPARAM mp1, MPARAM, int *dodefault)
{
    return MsgPresParamChanged(LONGFROMMP(mp1), dodefault);
}
MRESULT StdWinPlus::MsgPresParamChanged(ULONG, int *dodefault)
{
    *dodefault = 1;
    return 0;
}
