#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <errno.h>

int fstat (int fd, struct stat *buf)
{
   FILESTATUS fs;
   ULONG rc;
   struct tm tim;
   ULONG HandType;
   ULONG FlagWord;

   rc = DosQueryFileInfo (fd, 1, (PBYTE)&fs, sizeof (FILESTATUS));

   if (rc)
   {
      if (rc == ERROR_ACCESS_DENIED)
      {
         errno = EACCES;
         return (-1);
      }

      if (rc == ERROR_INVALID_HANDLE)
      {
         errno = EBADF;
         return (-1);
      }

      errno = EIO;
      return (-1);
   }

   bzero(&tim, sizeof(tim));
   if (fs.fdateCreation.day == 0)
      buf->st_ctime = buf->st_mtime;
   else
   {
      tim.tm_sec  = fs.ftimeCreation.twosecs;
      tim.tm_min  = fs.ftimeCreation.minutes;
      tim.tm_hour = fs.ftimeCreation.hours;
      tim.tm_mday = fs.fdateCreation.day;
      tim.tm_mon  = fs.fdateCreation.month - 1;
      tim.tm_year = fs.fdateCreation.year + 80;
      tim.tm_wday = tim.tm_yday = tim.tm_isdst = tim.tm_gmtoff = 0;
      tim.tm_zone = NULL;

      buf -> st_ctime = mktime (&tim);
   }

   if (fs.fdateLastAccess.day == 0)
      buf->st_atime = buf->st_mtime;
   else
   {
      tim.tm_sec  = fs.ftimeLastAccess.twosecs;
      tim.tm_min  = fs.ftimeLastAccess.minutes;
      tim.tm_hour = fs.ftimeLastAccess.hours;
      tim.tm_mday = fs.fdateLastAccess.day;
      tim.tm_mon  = fs.fdateLastAccess.month - 1;
      tim.tm_year = fs.fdateLastAccess.year + 80;
      tim.tm_wday = tim.tm_yday = tim.tm_isdst = tim.tm_gmtoff = 0;
      tim.tm_zone = NULL;

      buf -> st_atime = mktime (&tim);
   }

   tim.tm_sec  = fs.ftimeLastWrite.twosecs;
   tim.tm_min  = fs.ftimeLastWrite.minutes;
   tim.tm_hour = fs.ftimeLastWrite.hours;
   tim.tm_mday = fs.fdateLastWrite.day;
   tim.tm_mon  = fs.fdateLastWrite.month - 1;
   tim.tm_year = fs.fdateLastWrite.year + 80;
   tim.tm_wday = tim.tm_yday = tim.tm_isdst = tim.tm_gmtoff = 0;
   tim.tm_zone = NULL;

   buf -> st_mtime = mktime (&tim);

   buf -> st_size = fs.cbFile;
   buf -> st_blksize = 4096;

   buf -> st_ino = 0;
   buf -> st_nlink = 1;
   buf -> st_uid = 0;
   buf -> st_gid = 0;

   rc = DosQueryHType (fd, &HandType, &FlagWord);

   if (rc)
   {
      errno = EBADF;
      return (-1);
   }

   switch (HandType & 0xff)
   {
      case 0:
         buf -> st_mode = fs.attrFile & FILE_DIRECTORY ? S_IFDIR : S_IFREG;
         break;

      case 1:
         buf -> st_mode = S_IFCHR;
         break;

      case 2:
         buf -> st_mode = S_IFIFO;
         break;

   }

   return (0);
}

