#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>

static int initial_io[3] = { 0,0,0 };
static int textio_size = 3;
int *__textio = initial_io;
char __textbuf[8096];

int __expand_io_if_needed(int maxfd)
{
  if (maxfd >= textio_size)
    {
      /* Allocate a bigger space */
      int new_textio_size = maxfd + 16;
      int *new_textio = malloc(sizeof(int) * new_textio_size);
      if (new_textio == 0)
	return -1;

      /* Copy the old textio into the new space */
      memcpy(new_textio, __textio, textio_size * sizeof(int));
      memset(new_textio+textio_size, 0, 
	     (new_textio_size-textio_size) * sizeof(int));

      /* Release the old textio */
      if (__textio != initial_io)
	free(__textio);

      /* Update the textio information */
      __textio = new_textio;
      textio_size = new_textio_size;
   }
  return 0;
}

int open (const char *path, int flags, ...)
{
   ULONG rc;
   HFILE handle;
   ULONG ActionTaken;
   ULONG FileAttributes = FILE_NORMAL;
   ULONG open_mode = 0;
   ULONG open_flag = 0;
   va_list list;
   int mode;
   int *new_textio;
   int new_textio_size;
   int first_try = 1;

   if (path == 0) {
       errno = EINVAL;
       return (-1);
   }

   switch(flags & O_ACCMODE) {
   default:
   case O_RDONLY:
       open_mode = OPEN_ACCESS_READONLY;
       break;
   case O_WRONLY:
       open_mode = OPEN_ACCESS_WRITEONLY;
       break;
   case O_RDWR:
       open_mode = OPEN_ACCESS_READWRITE;
       break;
   }


   /* If we will be creating a file, determine its attributes */
   if (flags & O_CREAT)
   {
      va_start(list, flags);
      mode = va_arg(list, int);
      va_end(list);
      if (mode == S_IREAD)
         FileAttributes = FILE_READONLY;
      else
         FileAttributes = FILE_NORMAL;
   }

   /* Determine what to do if file doesn't exist */
   if (flags & O_CREAT) {
       open_flag |= OPEN_ACTION_CREATE_IF_NEW;
   } else {
       open_flag |= OPEN_ACTION_FAIL_IF_NEW;
   }

   /* Determine what to do if file does exist */
   if (flags & O_EXCL) {
       open_flag |= OPEN_ACTION_FAIL_IF_EXISTS;
   } else if (flags & O_TRUNC) {
       open_flag |= OPEN_ACTION_REPLACE_IF_EXISTS;
   } else {
       open_flag |= OPEN_ACTION_OPEN_IF_EXISTS;
   }

   if ((flags & O_ACCMODE) == O_RDONLY) {
       open_flag = OPEN_ACTION_OPEN_IF_EXISTS;
       FileAttributes = 0;
   }

retry_alloc:

   rc = DosOpen ((PSZ)path,
                   &handle,
                   &ActionTaken,
                   0,
                   FileAttributes,
                   open_flag,
                   OPEN_SHARE_DENYNONE | open_mode,
                   0);

   if (rc)
   {
       switch(rc) {
       case ERROR_FILE_NOT_FOUND:
       case ERROR_PATH_NOT_FOUND:
       case ERROR_OPEN_FAILED:
	   errno = ENOENT;
	   break;
       case ERROR_TOO_MANY_OPEN_FILES:
	   if (first_try) {
	       /* Try to allocate more files for this process */
	       LONG more_files = 32;
	       ULONG new_file_max;
	       rc = DosSetRelMaxFH(&more_files, &new_file_max);
	       first_try = 0;
	       if (rc == 0) goto retry_alloc;
	   }
	   errno = EMFILE;
	   break;
       case ERROR_ACCESS_DENIED:
       case ERROR_INVALID_ACCESS:
       case ERROR_SHARING_VIOLATION:
	   errno = EACCES;
	   break;
       case ERROR_DISK_FULL:
	   errno = ENOSPC;
	   break;
       case ERROR_FILENAME_EXCED_RANGE:
	   errno = ENAMETOOLONG;
	   break;
       default:
	   errno = EIO;
	   break;
       }
       return (-1);
   }

   /* Dynamically expand __textio array - cjensen */
   if (__expand_io_if_needed(handle) == -1)
     {
       DosClose(handle);
       errno = ENOMEM;
       return -1;
     }

   __textio[handle] = flags;

   /* Append, if necessary */
   if (flags & O_APPEND) {
       lseek(handle, 0, 2);
   }

   return (handle);
}

